/**
* @file    GdkToolOutputCfg.h
* @brief   Declares the GdkToolOutputCfg class.
*
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_TOOL_OUTPUT_CFG_H
#define GDK_TOOL_OUTPUT_CFG_H

#include <Gdk/GdkDef.h>

/**
* Represents the configuration output object base class.
* This can be one of GdkMeasurementCfg, GdkFeatureCfg or
* GdkToolDataOutputCfg.
*
* @class       GdkToolOutputCfg
* @ingroup     Gdk-Config
*/
typedef kPointer GdkToolOutputCfg;

GdkFx(GdkToolOutputType) GdkToolOutputCfg_OutputType(GdkToolOutputCfg config);

GdkFx(k32s) GdkToolOutputCfg_Id(GdkToolOutputCfg config);

GdkFx(const kChar*) GdkToolOutputCfg_Name(GdkToolOutputCfg config);

#endif 
