/** 
 * @file    GdkGraphicAnchorRegion2d.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GDK_GRAPHIC_ANCHOR_REGION_2D_X_H
#define GDK_GRAPHIC_ANCHOR_REGION_2D_X_H

#include <kApi/Data/kMath.h>
#include <kApi/Data/kArrayList.h>

#include <Gdk/GdkDef.h>

typedef struct GdkGraphicAnchorRegion2dClass
{
    GdkGraphicAnchorRegionClass base;
    k64f x, z;
    k64f width, height;
    k64f angle; //About y Axis
} GdkGraphicAnchorRegion2dClass; 

kDeclareClassEx(Gdk, GdkGraphicAnchorRegion2d, GdkGraphicAnchorRegion)

#define GdkGraphicAnchorRegion2dTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicAnchorRegion2d))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicAnchorRegion2d_Init(GdkGraphicAnchorRegion2d graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphicAnchorRegion2d_Release(GdkGraphicAnchorRegion2d graphic); 

GdkFx(kStatus) GdkGraphicAnchorRegion2d_VRelease(GdkGraphicAnchorRegion2d graphic);
GdkFx(kStatus) GdkGraphicAnchorRegion2d_VSerialize(GdkGraphicAnchorRegion2d anchorRegion, kSerializer serializer);

#endif
