/** 
 * @file    GdkCircleFeature.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.
 * Licensed under the MIT License.
 * Redistributed files must retain the above copyright notice.
 */
#ifndef GDK_CIRCLE_FEATURE_X_H
#define GDK_CIRCLE_FEATURE_X_H

typedef struct GdkCircleFeatureClass
{
    GdkFeatureClass base;
    k64f radius;
} GdkCircleFeatureClass;

#define GdkCircleFeatureTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkCircleFeature))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkCircleFeature_Construct(GdkCircleFeature* feature, kAlloc alloc);
GdkFx(kStatus) GdkCircleFeature_Init(GdkCircleFeature feature, kType type, kAlloc allocator);
GdkFx(kStatus) GdkCircleFeature_VRelease(GdkCircleFeature feature);
GdkFx(kStatus) GdkCircleFeature_VInitClone(GdkCircleFeature feature, GdkCircleFeature source, kAlloc allocator);

#endif
