/**
* @file    GdkToolDataOutputInfo.h
* @brief   Declares the GdkToolDataOutputInfo class.
*
* Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_TOOLDATA_OUTPUT_INFO_H
#define GDK_TOOLDATA_OUTPUT_INFO_H

#include <Gdk/GdkDef.h>
#include <Gdk/Tools/GdkOutputInfo.h>
#include <Gdk/Config/GdkParamsInfo.h>

/**
* Describes a GdkToolDataOutputInfo type.
*
* @class       GdkToolDataOutputInfo
* @extends     kObject
* @ingroup     Gdk-Tools
*/
typedef kObject GdkToolDataOutputInfo;
kDeclareClassEx(Gdk, GdkToolDataOutputInfo, GdkOutputInfo)


GdkFx(kStatus) GdkToolDataOutputInfo_Construct(GdkToolDataOutputInfo* info, kAlloc alloc);

/**
* Returns the GdkToolDataOutputInfo type name.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Label of GdkToolDataOutputInfo.
*/
GdkFx(const kChar*) GdkToolDataOutputInfo_Label(GdkToolDataOutputInfo info);

/**
* Sets the GdkToolDataOutputInfo type.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    type        GdkToolDataOutputInfo type.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetType(GdkToolDataOutputInfo info, const kChar* type);

/**
* Returns the GdkToolDataOutputInfo type.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Label of GdkToolDataOutputInfo.
*/
GdkFx(const kChar*) GdkToolDataOutputInfo_Type(GdkToolDataOutputInfo info);

/**
* Sets the GdkToolDataOutputInfo data type.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    dataType    GdkToolDataOutputInfo data type.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetDataType(GdkToolDataOutputInfo info, GdkDataType dataType);

/**
* Returns the GdkToolDataOutputInfo data type.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Data type of GdkToolDataOutputInfo.
*/
GdkFx(GdkDataType) GdkToolDataOutputInfo_DataType(GdkToolDataOutputInfo info);

/**
* Sets the minimum number of instances within a tool.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    count       Minimum instance count.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetMinCount(GdkToolDataOutputInfo info, kSize count);

/**
* Returns the minimum number of instances within a tool.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Minimum instance count.
*/
GdkFx(kSize) GdkToolDataOutputInfo_MinCount(GdkToolDataOutputInfo info);

/**
* Sets the maximum number of instances within a tool.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    count       Maximum instance count.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetMaxCount(GdkToolDataOutputInfo info, kSize count);

/**
* Returns the maximum number of instances within a tool.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Maximum instance count.
*/
GdkFx(kSize) GdkToolDataOutputInfo_MaxCount(GdkToolDataOutputInfo info);

/**
* Returns the schema for the parameters.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               Params info.
*/
GdkFx(GdkParamsInfo) GdkToolDataOutputInfo_Params(GdkToolDataOutputInfo info);

/* Sets the flag indicating whether intensity is available with the tool data output stream.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    hasIntensity Flag indicating intensity will be included.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetHasIntensity(GdkToolDataOutputInfo info, kBool hasIntensity);

/**
* Returns the flag indicating if intensity is to be included with the tool data output.
*
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @return               kTRUE if intensity to be included, FALSE otherwise.
*/
GdkFx(kBool) GdkToolDataOutputInfo_HasIntensity(GdkToolDataOutputInfo info);


//// Deprecated API functions

/**
* [Deprecated] Set label through GdkToolInfo_AddOutput() instead.
*
* Sets the GdkToolDataOutputInfo type name.
*
* @deprecated
* @public               @memberof GdkToolDataOutputInfo
* @param    info        Info object.
* @param    name        Label of GdkToolDataOutputInfo.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputInfo_SetLabel(GdkToolDataOutputInfo info, const kChar* name);

#endif

