/** 
 * @file    Asm.cpp
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#include <GdkAppSample/Asm.h>
#include <GdkAppSample/TestProfileSelect.h>
#include <GdkAppSample/TestSurfaceSelect.h>
#include <GdkAppSample/TestSurfaceConfiguration.h>
#include <GdkAppSample/TestSurfaceGraphics.h>
#include <GdkAppSample/TestFeatureAverage.h>
#include <GdkAppSample/TestSurfaceFeatures.h>
#include <GdkAppSample/TestProfileDynamicAlignment.h>
#include <GdkAppSample/TestSurfaceDynamicAlignment.h>
#include <GdkAppSample/TestDynamicOutputs.h>
#include <GdkAppSample/TestGenericInput.h>
#include <GdkAppSample/TestMesh.h>
#include <Gdk/GdkLib.h>
#include <GoSensor/Version.h>
#include <GoSensorAppLib/GsaDef.h>
#include <GoSensorAppLib/GsaAsm.h>

// "ToolAsm" is the name of this GDK library. 
// This name must match the name used in kDeclareAssemblyEx() declaration in Asm.x.h.
kBeginAssemblyEx(Tool, ToolAsm, TOOL_VERSION, GOCATOR_VERSION)
    kAddDependency(GdkLib)
    kAddType(TestProfileSelect)
    kAddType(TestSurfaceSelect)
    kAddType(TestSurfaceConfiguration)
    kAddType(TestSurfaceGraphics)
    kAddType(TestFeatureAverage)
    kAddType(TestSurfaceFeatures)
    kAddType(TestProfileDynamicAlignment)
    kAddType(TestSurfaceDynamicAlignment)
    kAddType(TestDynamicOutputs)
    kAddType(TestGenericInput)
    kAddType(TestMesh)
kEndAssemblyEx()

#if !defined(GO_GDK_DYNAMIC)
kExtern kStatus kCall GoSensorAppLib_ConstructAssembly(kAssembly* userAsm)
{
    return ToolAsm_Construct(userAsm);
}
#endif
