#ifndef TEST_PROFILE_DYNAMIC_ALIGNMENT_TOOL_X_H
#define TEST_PROFILE_DYNAMIC_ALIGNMENT_TOOL_X_H

#include <kVision/S3d/kS3dUtilities.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>

#define TEST_PROFILE_DYNAMIC_ALIGNMENT_TOOL_NAME    "TestProfileDynamicAlignment"
#define TEST_PROFILE_DYNAMIC_ALIGNMENT_TOOL_LABEL   "Test Profile Dynamic Alignment"

#define MIN_POINTS               3

#define PARAM_REGION1_NAME       "Region1"
#define PARAN_REGION1_LABEL      PARAM_REGION1_NAME    
#define PARAM_REGION2_NAME       "Region2"
#define PARAN_REGION2_LABEL      PARAM_REGION2_NAME    
#define PARAM_NUM_REGION_NAME    "NumRegions"
#define PARAM_NUM_REGION_LABEL   "Number of Reference Regions"

#define MEAS_ANGLE_NAME          "Angle"
#define MEAS_ANGLE_LABEL         MEAS_ANGLE_NAME            
#define MEAS_ANGLE_INDEX         0
#define MEAS_INTERCEPT_NAME      "Intercept"
#define MEAS_INTERCEPT_LABEL     MEAS_INTERCEPT_NAME
#define MEAS_INTERCEPT_INDEX     1

#define OUTPUT_ALIGNED_NAME      "AlignedProfile"
#define OUTPUT_ALIGNED_LABEL     "Aligned Profile"
#define OUTPUT_ALIGNED_INDEX     2

typedef struct TestProfileDynamicAlignmentClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

    GdkRegionXZ64f region1;
    GdkRegionXZ64f region2;

} TestProfileDynamicAlignmentClass;

kDeclareClassEx(Tool, TestProfileDynamicAlignment, GdkTool)

ToolFx(const kChar*) TestProfileDynamicAlignment_VName();
ToolFx(kStatus) TestProfileDynamicAlignment_VDescribe(GdkToolInfo info);
ToolFx(kStatus) TestProfileDynamicAlignment_VStart(TestProfileDynamicAlignment tool);
ToolFx(kStatus) TestProfileDynamicAlignment_VStop(TestProfileDynamicAlignment tool);
ToolFx(kStatus) TestProfileDynamicAlignment_VProcess(TestProfileDynamicAlignment tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestProfileDynamicAlignment_VInit(TestProfileDynamicAlignment tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestProfileDynamicAlignment_VRelease(TestProfileDynamicAlignment tool);
ToolFx(kStatus) TestProfileDynamicAlignment_VNewToolConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestProfileDynamicAlignment_VNewMeasurementConfig(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
ToolFx(kStatus) TestProfileDynamicAlignment_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);

ToolFx(kStatus) TestProfileDynamicAlignment_OutputValue(GdkToolOutput output, kSize index, k64f value, kBool valid, GdkToolCfg config);

#endif



