#ifndef GSA_LIB_SENSOR_G1_PROPERTIES_H
#define GSA_LIB_SENSOR_G1_PROPERTIES_H

#include "SensorBase.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct SpotDetection : public GoProp::Structure
{
    GoProp::Value<k32s> threshold;
    MinMaxValue<k32s> maxWidth;
    GoProp::Value<k32s> selectionType;
    GoProp::Value<std::vector<k32s>> selectionTypeOptions;

    SpotDetection()
    {
        Register("threshold", threshold);
        Register("maxWidth", maxWidth);
        
        Register("selectionType", selectionType);
        selectionType.RegisterSchema("enum", selectionTypeOptions);
    }
};

struct G1SensorSchema : public SensorBase
{
    SpotDetection spotDetection;

    G1SensorSchema()
    {
        Register("spotDetection", spotDetection);
    }
};

}; // namespaces

#endif
