#ifndef GSA_LIB_SENSOR_G2_PROPERTIES_H
#define GSA_LIB_SENSOR_G2_PROPERTIES_H

#include "SensorBase.h"
#include "SensorG1.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct SearchWindow : public GoProp::Structure
{
    GoProp::Value<k32s> width = GS_CONTINUITY_SORTING_SEARCH_WINDOW;
    GoProp::Value<k32s> length = GS_CONTINUITY_SORTING_SEARCH_WINDOW;

    SearchWindow()
    {
        Register("width", width);
        Register("length", length);
    }
};

struct ContinuitySorting : public GoProp::Structure
{
    GoProp::Value<k32s> minSegmentSize = GS_CONTINUITY_SORTING_MIN_LENGTH;
    SearchWindow searchWindow;

    ContinuitySorting()
    {
        Register("minSegmentSize", minSegmentSize);
        Register("searchWindow", searchWindow);
        
    }
};

struct G2SpotDetection : public SpotDetection
{
    ContinuitySorting continuitySorting;

    G2SpotDetection()
    {
        Register("continuitySorting", continuitySorting);
    }
};

struct Tracking : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    GoProp::Value<k64f> height;
    GoProp::Value<k64f> searchThreshold;

    Tracking()
    {
        Register("enabled", enabled);
        Register("height", height);
        Register("searchThreshold", searchThreshold);
    }
};

struct G2SensorSchema : public SensorBase
{
    GoProp::Value<k32s> intensityMode;
    GoProp::Value<std::vector<k32s>> intensityModeOptions;
    GoProp::Value<k64u> intensityExposureIndex;

    G2SpotDetection spotDetection;
    Tracking tracking;
    GoProp::Value<bool> trackingUsed;

    G2SensorSchema()
    {
        Register("intensityMode", intensityMode);
        intensityModeOptions.Set({ 0,1 });
        intensityMode.RegisterSchema("enum", intensityModeOptions);
        Register("intensityExposureIndex", intensityExposureIndex);

        Register("spotDetection", spotDetection);
        Register("tracking", tracking);
        tracking.RegisterSchema("used", trackingUsed);
    }
};

}; // namespaces

#endif
