/**\file    ResourceManager.h
 * Resource Manager class
 */

#ifndef GSA_LIB_RESOURCE_MANAGER_H
#define GSA_LIB_RESOURCE_MANAGER_H

#include <GoServices/Connections/ConnectionsManager.h>

#include <GoRest/ResourceRouter.h>

// Standard resources.
#include <GoServices/Resources/SystemMapping/ToolModule.h>
#include <GoServices/Resources/SystemMapping/DataSourcesModule.h>
#include <GoServices/Resources/SystemMapping/ConnectionsModule.h>
#include <GoServices/Resources/SystemMapping/LogsModule.h>
#include <GoServices/Resources/SystemMapping/ProblemsModule.h>

// Classic resources.
#include <GoSensorAppLib/StudioProtocol/SystemModule.h>
#include <GoSensorAppLib/StudioProtocol/ScannerModule.h>
#include <GoSensorAppLib/StudioProtocol/SensorModule.h>
#include <GoSensorAppLib/StudioProtocol/JobsModule.h>

#include <GoSensor/Studio/Core2.h>

namespace GoSensorApp
{

class GsaClass ResourceManager
{
public:
    ResourceManager(GoCore::Core2& core, GoRest::ResourceRouter& router);

private:
    GoRest::ResourceRouter router;
      
    SystemModule system;
    ScannerModule scanner;
    SensorModule sensor;
    JobsModule jobs;
    GoServices::Resources::ToolModule tools;
    GoServices::Resources::DataSourcesModule dataSources;
    // TODO: This is just a hack to get Studio Metrics compil-able
    // for GoSensorApp and GoSensorAppTest purposes.
    // GoStudioFirmware has better and clearer separation between domain and protocol levels.
    std::unique_ptr<GoServices::ConnectionsManager> connectionsMgr;
    GoServices::Resources::ConnectionsModule connections;
    GoServices::Resources::LogsModule logs;
    GoServices::Resources::ProblemsModule problems;
};

/*! \class ResourceManager ResourceManager.h 
*  \brief Resource Manager class in charge of creating and registering resources in the system
*  \ingroup GoServices-Resources
*/

}; // namespaces

#endif
