#ifndef GV_MEASURE_MSG_H
#define GV_MEASURE_MSG_H

#include <GoVision/GvDef.h>
#include <kFireSync/Data/kMsgSet.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArrayList.h>

typedef kMsgSet GvMeasureMsg;

/** 
 * Sets the value of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @param   value       Value of the measurement.
 * @return              Operation status.
 */
GvFx(kStatus) GvMeasureMsg_SetValue(GvMeasureMsg msg, k64f value);

/** 
 * Gets the value of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @return              Value of measurement.
 */
GvFx(k64f) GvMeasureMsg_Value(GvMeasureMsg msg);

/** 
 * Sets the status of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @param   status      Status of the measurement. Can be one of:
 *                      GDK_MEASUREMENT_OK
 *                      GDK_MEASUREMENT_ERROR_VALUE
 *                      GDK_MEASUREMENT_ERROR_ANCHOR
 *                      GDK_MEASUREMENT_ERROR_PART_MATCH
 * @return              Operation status.
 */
GvFx(kStatus) GvMeasureMsg_SetStatus(GvMeasureMsg msg, GdkMeasurementDecision status);

/** 
 * Gets the status of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @return              Status of measurement. Can be one of:
 *                      GDK_MEASUREMENT_OK
 *                      GDK_MEASUREMENT_ERROR_VALUE
 *                      GDK_MEASUREMENT_ERROR_ANCHOR
 *                      GDK_MEASUREMENT_ERROR_PART_MATCH
 */
GvFx(GdkMeasurementDecision) GvMeasureMsg_Status(GvMeasureMsg msg);

/** 
 * Sets the result position of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @param   position    Pointer to result position of the measurement.
 * @return              Operation status.
 */
GvFx(kStatus) GvMeasureMsg_SetResultPosition(GvMeasureMsg msg, kPoint3d64f* position);

/** 
 * Gets the result position of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @return              Result position of measurement.
 */
GvFx(kPoint3d64f) GvMeasureMsg_ResultPosition(GvMeasureMsg msg);

/** 
 * Sets the Label position of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @param   x           x position of the measurement.
 * @param   y           y position of the measurement.
 * @param   z           z position of the measurement.
 * @return              Operation status.
 */
GvFx(kStatus) GvMeasureMsg_SetLabelPosition(GvMeasureMsg msg, k64f x, k64f y, k64f z);

/** 
 * Gets the label position of the measurement.
 *
 * @public              @memberof GvMeasureMsg
 * @param   msg         Message object. 
 * @return              label position of measurement pointer.
 */
GvFx(const kPoint3d64f*) GvMeasureMsg_LabelPosition(GvMeasureMsg msg);

/**
 * Sets the rendering object within the message.
 *
 * @public               @memberof GvMeasureeMsg
 * @param    msg         Message object.
 * @param    object      Rendering object (GdkGraphic until Studio migrates to newer primitives).
 * @return               Operation status.
 */
GvFx(kStatus) GvMeasureMsg_SetRendering(GvMeasureMsg msg, kObject object);

/**
 * Retrieves the rendering object from the message.
 *
 * @public               @memberof GvMeasureMsg 
 * @param    msg         Message object.
 * @return               Rendering object (GdkGraphic until Studio migrates to newer primitives).
 */
GvFx(kObject) GvMeasureMsg_Rendering(GvMeasureMsg msg);

#include <GoVision/Data/GvMeasureMsg.x.h>

#endif
