/** 
 * @file    kAxAction.x.h
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_AX_ACTION_X_H
#define K_FIRESYNC_AX_ACTION_X_H

typedef struct kAxActionClass
{
    kObjectClass base; 
    kAxEnviron actionEnviron;           //Provides services from execution environment.
    kText32 name;                       //Instance name. 
    kActionTrigger trigger;             //Trigger source type.
    kXml settings;                      //XML settings. 
} kAxActionClass; 

typedef struct kAxActionVTable
{
    kObjectVTable base; 
    
    const kChar* (kCall* VDescription)();
    kStatus (kCall* VValidate)(kXml settings, kAlloc alloc);
    kStatus (kCall* VInit)(kAxAction action, kType type, const kChar* name, kActionTrigger trigger, kAxEnviron actionEnviron, kAlloc alloc);
    kStatus (kCall* VInvoke)(kAxAction action, kObject input, kObject* output, kAlloc alloc);

} kAxActionVTable; 

kDeclareVirtualClassEx(kFs, kAxAction, kObject)

kFsFx(const kChar*) kAxAction_VDescription();
kFsFx(kStatus) kAxAction_VValidate(kXml settings, kAlloc alloc);
kFsFx(kStatus) kAxAction_VInit(kAxAction action, kType type, const kChar* name, kActionTrigger trigger, kAxEnviron actionEnviron, kAlloc alloc);
kFsFx(kStatus) kAxAction_VRelease(kAxAction action);
kFsFx(kStatus) kAxAction_VInvoke(kAxAction action, kObject input, kObject* output, kAlloc alloc);

#endif
