/** 
 * @file    kCameraCalibrationAction.x.h
 * 
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_CALIBRATION_ACTION_X_H
#define K_FIRESYNC_CAMERA_CALIBRATION_ACTION_X_H

#include <kFireSync/Action/kAxAction.h>

#define kCAMERA_CALIBRATION_ACTION_TIMEOUT               (3000000)
#define kCAMERA_CALIBRATION_ACTION_POLL_INTERVAL         (10000)
#define kCAMERA_CALIBRATION_ACTION_FRAME_COUNT           (160)

//The calibration uses lots of CPU resource and the period for release mode is pick
//for the sake of best performance. It wouldn't work in debug mode.
//As a result, the period for debug mode needs to be larger than release mode.
#define kCAMERA_CALIBRATION_ACTION_PERIOD_DEBUG          (2048000)
#define kCAMERA_CALIBRATION_ACTION_PERIOD_RELEASE        (1024000)

//FSS-1429: We have seen that with some LC2500 cameras, non-fatal acquisition errors can sometimes occur
//in the first frame after boot. When this happens, FPN calibration can be affected. To add resiliancy, 
//we are implementing a limited number of retries. 
#define kCAMERA_CALIBRATION_ACTION_MAX_ATTEMPT_COUNT     (3)   

#define kCAMERA_CALIBRATION_ACTION_MODE_CONFIG_PATH      ("/temp/ModeConfig.kcfg")

typedef struct kCameraCalibrationActionClass
{
    kAxActionClass base; 
    kArrayList cameras;
    kArrayList lvdsPowers;
} kCameraCalibrationActionClass; 

kDeclareClassEx(kFs, kCameraCalibrationAction, kAxAction)

kFsFx(const kChar*) kCameraCalibrationAction_VDescription();
kFsFx(kStatus) kCameraCalibrationAction_VValidate(kXml settings, kAlloc alloc);
kFsFx(kStatus) kCameraCalibrationAction_VInvoke(kCameraCalibrationAction action, kObject input, kObject* output, kAlloc alloc);

kFsFx(kStatus) kCameraCalibrationAction_BuildCameraList(kCameraCalibrationAction action, kNode node);
kFsFx(kStatus) kCameraCalibrationAction_Calibrate(kCameraCalibrationAction action, kObject* output, kAlloc alloc);
kFsFx(kStatus) kCameraCalibrationAction_SaveLvdsPower(kCameraCalibrationAction action);
kFsFx(kStatus) kCameraCalibrationAction_RestoreLvdsPower(kCameraCalibrationAction action);
kFsFx(kStatus) kCameraCalibrationAction_ConfigureNode(kCameraCalibrationAction action, k32u left, k32u width);
kFsFx(kStatus) kCameraCalibrationAction_Run(kCameraCalibrationAction action, kSize frameCount);
kFsFx(kStatus) kCameraCalibrationAction_CheckForErrors(kCameraCalibrationAction action); 

#endif
