/** 
 * @file    kLvdsSetDelayAction.x.h
 * 
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_LVDS_SET_DELAY_ACTION_X_H
#define K_FIRESYNC_LVDS_SET_DELAY_ACTION_X_H

#include <kFireSync/Action/kAxAction.h>
#include <kFireSync/Actions/kLvdsEyeAction.x.h>

#define kLVDS_SET_DELAY_ACTION_DEFAULT_TAPS_PER_BIT     (13)

typedef struct kLvdsSetDelayActionClass
{
    kAxActionClass base; 
    kNode node;
    kCamera camera;
    kArrayList channels;

    k32u tapsPerBit;
    kLvdsEyeDiagram eyeDiagram[kLVDS_EYE_ACTION_CHANNEL_COUNT];
} kLvdsSetDelayActionClass; 

kDeclareClassEx(kFs, kLvdsSetDelayAction, kAxAction)

kFsFx(const kChar*) kLvdsSetDelayAction_VDescription();
kFsFx(kStatus) kLvdsSetDelayAction_VValidate(kXml settings, kAlloc alloc);
kFsFx(kStatus) kLvdsSetDelayAction_VInvoke(kLvdsSetDelayAction action, kObject input, kObject* output, kAlloc alloc);

kFsFx(kStatus) kLvdsSetDelayAction_Setup(kLvdsSetDelayAction action);
kFsFx(kStatus) kLvdsSetDelayAction_SetDpa(kLvdsSetDelayAction action);
kFsFx(kBool) kLvdsSetDelayAction_ParseInput(kLvdsSetDelayAction action, kXml input);
kFsFx(kStatus) kLvdsSetDelayAction_SetDelay(kLvdsSetDelayAction action);

kFsFx(kStatus) kLvdsSetDelayAction_SetChannelDelay(kLvdsSetDelayAction action, kSize index, k32s adjustDelay);

#endif
