/** 
 * @file    kMemoryTrafficActionInfo.h
 * @brief   Declares the kMemoryTrafficActionInfo class. 
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_ACTION_INFO_H
#define K_FIRESYNC_MEMORY_TRAFFIC_ACTION_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kMemoryTrafficActionInfo
 * @extends kObject
 * @ingroup kFireSync-Actions
 * @brief   Represents configuration for kMemoryTrafficAction. 
 */
//typedef kObject kMemoryTrafficActionInfo;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kMemoryTrafficActionInfo object. 
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Receives constructed info object. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
 kFsFx(kStatus) kMemoryTrafficActionInfo_Construct(kMemoryTrafficActionInfo* info, kAlloc allocator); 

/** 
 * Constructs a kMemoryTrafficActionInfo object and loads its content from an XML object. 
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Receives constructed info object.  
 * @param   xml         Source from which parameters are loaded. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Load(kMemoryTrafficActionInfo* info, kXml xml, kAlloc allocator); 

/** 
 * Constructs a kXml object and uses it to store the content of this kMemoryTrafficActionInfo instance.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.  
 * @param   xml         Receives constructed kXml object.
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Store(kMemoryTrafficActionInfo info, kXml* xml, kAlloc allocator); 

/** 
 * Reads kMemoryTrafficActionInfo state from a kXml object. 
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Read(kMemoryTrafficActionInfo info, kXml xml, kXmlItem item); 

/** 
 * Writes kMemoryTrafficActionInfo state to a kXml object. 
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.  
 * @param   xml         XML object. 
 * @param   item        XML item.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Write(kMemoryTrafficActionInfo info, kXml xml, kXmlItem item); 

/** 
 * Checks and automatically corrects all state variables. 
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Validate(kMemoryTrafficActionInfo info); 

/** 
 * Resets all state variables to default values.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_Clear(kMemoryTrafficActionInfo info); 

/**
 * Gets the buffer size in bytes.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @return              Size of buffer allocated.
 */
kFsFx(kSize) kMemoryTrafficActionInfo_BufferSize(kMemoryTrafficActionInfo info);

/**
 * Gets the operation type.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @return              Operation type.
 */
kFsFx(kMemoryTrafficOp) kMemoryTrafficActionInfo_Operation(kMemoryTrafficActionInfo info);

/**
 * Gets the number of threads requested by the user.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @return              Number of active threads performing an operation.
 */
kFsFx(kSize) kMemoryTrafficActionInfo_ThreadCount(kMemoryTrafficActionInfo info);

/**
 * Sets the buffer size in bytes.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @param   bufferSize  Requested buffer size.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_SetBufferSize(kMemoryTrafficActionInfo info, kSize bufferSize);

/**
 * Sets the operation type.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @param   operation   Operation type.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_SetOperation(kMemoryTrafficActionInfo info, kMemoryTrafficOp operation);

/**
 * Sets the number of threads requested by the user.
 *
 * @public              @memberof kMemoryTrafficActionInfo
 * @param   info        Info object.
 * @param   count       Number of threads performing an operation.
 * @return              Operation status.
 */
kFsFx(kStatus) kMemoryTrafficActionInfo_SetThreadCount(kMemoryTrafficActionInfo info, kSize count);

#include <kFireSync/Actions/kMemoryTrafficActionInfo.x.h>

#endif
