/** 
 * @file    kLc250xFpnBlockInfo.h
 * @brief   Declares the kLc250xFpnBlockInfo class. 
 *
 * @internal
 * Copyright (C) by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC250X_FPN_BLOCK_INFO_H
#define K_FIRESYNC_LC250X_FPN_BLOCK_INFO_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kLc250xFpnBlockInfo
 * @extends kObject
 * @ingroup kFireSync-Blocks
 * @brief   Represents configuration for kLc250xFpnBlock. 
 */
//typedef kObject kLc250xFpnBlockInfo;        --forward-declared in kFsDef.x.h

 kFsFx(kStatus) kLc250xFpnBlockInfo_Construct(kLc250xFpnBlockInfo* info, kAlloc allocator); 

kFsFx(kStatus) kLc250xFpnBlockInfo_Load(kLc250xFpnBlockInfo* info, kXml xml, kAlloc allocator); 
kFsFx(kStatus) kLc250xFpnBlockInfo_Store(kLc250xFpnBlockInfo info, kXml* xml, kAlloc allocator); 
kFsFx(kStatus) kLc250xFpnBlockInfo_Read(kLc250xFpnBlockInfo info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLc250xFpnBlockInfo_Write(kLc250xFpnBlockInfo info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLc250xFpnBlockInfo_Validate(kLc250xFpnBlockInfo info); 
kFsFx(kStatus) kLc250xFpnBlockInfo_Clear(kLc250xFpnBlockInfo info); 

kFsFx(kStatus) kLc250xFpnBlockInfo_SetCalibrationMode(kLc250xFpnBlockInfo info, k32u mode); 
kFsFx(k32u) kLc250xFpnBlockInfo_CalibrationMode(kLc250xFpnBlockInfo info); 

kFsFx(kStatus) kLc250xFpnBlockInfo_EnableHfpn(kLc250xFpnBlockInfo info, kBool enable); 
kFsFx(kBool) kLc250xFpnBlockInfo_HfpnEnabled(kLc250xFpnBlockInfo info); 

kFsFx(kStatus) kLc250xFpnBlockInfo_EnableVfpn(kLc250xFpnBlockInfo info, kBool enable); 
kFsFx(kBool) kLc250xFpnBlockInfo_VfpnEnabled(kLc250xFpnBlockInfo info); 

/** Gets the input port id. */
kInlineFx(k16u) kLc250xFpnBlockInfo_InputPortId() { return 0; }

/** Gets the output port id. */
kInlineFx(k16u) kLc250xFpnBlockInfo_OutputPortId() { return 1; }

kInlineFx(k16u) kLc250xFpnBlockInfo_HfpnCoefPortId() { return 2; }

#include <kFireSync/Blocks/kLc250xFpnBlockInfo.x.h>

#endif
