/** 
 * @file    kMemoryTrafficBlock.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_X_H
#define K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kMemoryTrafficBlockClass
{
    kPxBlockClass base; 
    kByte* source;
    kByte* dest;
    k64u temp;
    kMemoryTrafficBlockInfo info;          //Settings.
} kMemoryTrafficBlockClass; 

kDeclareClassEx(kFs, kMemoryTrafficBlock, kPxBlock)

kFsFx(const kChar*) kMemoryTrafficBlock_VDescription(); 

kFsFx(kStatus) kMemoryTrafficBlock_VOnSetup(kMemoryTrafficBlock block);
kFsFx(kStatus) kMemoryTrafficBlock_VOnStart(kMemoryTrafficBlock block);
kFsFx(kStatus) kMemoryTrafficBlock_VOnStop(kMemoryTrafficBlock block);
kFsFx(kStatus) kMemoryTrafficBlock_VOnReceive(kMemoryTrafficBlock block, kPxPort port, kMsgSet msg);

kFsFx(kStatus) kMemoryTrafficBlock_Read(kMemoryTrafficBlock block, kSize bufferSize, k64u byteCount);
kFsFx(kStatus) kMemoryTrafficBlock_Write(kMemoryTrafficBlock block, kSize bufferSize, k64u byteCount);
kFsFx(kStatus) kMemoryTrafficBlock_Copy(kMemoryTrafficBlock block, kSize bufferSize, k64u byteCount);

#endif
