/** 
 * @file    kMemoryTrafficBlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_INFO_X_H
#define K_FIRESYNC_MEMORY_TRAFFIC_BLOCK_INFO_X_H

#define kMEMORY_TRAFFIC_BLOCK_INFO_BUFFER_SIZE  (4000000)

typedef struct kMemoryTrafficBlockInfoClass
{
    kObjectClass base; 
    kSize bufferSize;
    k64u byteCount;
    kMemoryTrafficOp operation;
} kMemoryTrafficBlockInfoClass; 

kDeclareClassEx(kFs, kMemoryTrafficBlockInfo, kObject)
        
kFsFx(kStatus) kMemoryTrafficBlockInfo_Init(kMemoryTrafficBlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kMemoryTrafficBlockInfo_VRelease(kMemoryTrafficBlockInfo info); 

#endif
