/** 
 * @file    kTimerBlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TIMER_BLOCK_INFO_X_H
#define K_FIRESYNC_TIMER_BLOCK_INFO_X_H

#define kTIMER_BLOCK_INFO_DEFAULT_PERIOD        (1000000)

typedef struct kTimerBlockInfoClass
{
    kObjectClass base; 
    k64u period;            //Timer period, in microseconds. 
} kTimerBlockInfoClass; 

kDeclareClassEx(kFs, kTimerBlockInfo, kObject)
        
kFsFx(kStatus) kTimerBlockInfo_Init(kTimerBlockInfo info, kType type, kAlloc alloc); 
kFsFx(kStatus) kTimerBlockInfo_VRelease(kTimerBlockInfo info); 

#endif
