/** 
 * @file    kSobelwArcgdwInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SOBELW_ARCGDW_WIDE_INFO_X_H
#define K_FIRESYNC_SOBELW_ARCGDW_WIDE_INFO_X_H

#define kSOBELW_ARCGDW_INFO_MIN_EDGE_WINDOW         (5)
#define kSOBELW_ARCGDW_INFO_MAX_EDGE_WINDOW         (57)

#define kSOBELW_ARCGDW_INFO_MIN_EDGE_THRESHOLD      (0)
#define kSOBELW_ARCGDW_INFO_MAX_EDGE_THRESHOLD      (127)

#define kSOBELW_ARCGDW_INFO_WIDTH_LIMIT             (127)

#define kSOBELW_ARCGDW_INFO_CG_SCALE_SHIFT          (2)             //Effectively hard-coded in this PL config.

typedef struct kSobelwArcgdwInfoClass
{
    kAcgInfoClass base; 
} kSobelwArcgdwInfoClass; 

kDeclareClassEx(kFs, kSobelwArcgdwInfo, kAcgInfo)
        
kFsFx(kStatus) xkSobelwArcgdwInfo_ConstructFramework(kSobelwArcgdwInfo* info, kAlloc allocator);

kFsFx(kStatus) kSobelwArcgdwInfo_Init(kSobelwArcgdwInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kAlloc alloc); 

kFsFx(kStatus) kSobelwArcgdwInfo_VInitRead(kSobelwArcgdwInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kXml xml, kXmlItem item, kAlloc alloc);

kFsFx(kCameraAlgorithm) kSobelwArcgdwInfo_VId(kSobelwArcgdwInfo info); 
kFsFx(kType) kSobelwArcgdwInfo_VItemType(kSobelwArcgdwInfo info); 

/* 
* Deprecated (Stage 1): not recommended for further use, but not yet announced via kDeprecate
*/

//Deprecated: use kAcgInfo_EnableRanges
#define kSobelwArcgdwInfo_EnableRanges kAcgInfo_EnableRanges
//kDeprecate(kSobelwArcgdwInfo_EnableRanges)

//Deprecated: use kAcgInfo_RangesEnabled
#define kSobelwArcgdwInfo_RangesEnabled kAcgInfo_RangesEnabled
//kDeprecate(kSobelwArcgdwInfo_RangesEnabled)

//Deprecated: use kAcgInfo_RangesEnabledInfo
#define kSobelwArcgdwInfo_RangesEnabledInfo kAcgInfo_RangesEnabledInfo
//kDeprecate(kSobelwArcgdwInfo_RangesEnabledInfo)

//Deprecated: use kSobelwArcgdwInfo_SetEdgeThreshold
#define kSobelwArcgdwInfo_SetThreshold1 kSobelwArcgdwInfo_SetEdgeThreshold 
//kDeprecate(kSobelwArcgdwInfo_SetThreshold1)

//Deprecated: use kSobelwArcgdwInfo_EdgeThreshold
#define kSobelwArcgdwInfo_Threshold1 kSobelwArcgdwInfo_EdgeThreshold
//kDeprecate(kSobelwArcgdwInfo_Threshold1)

//Deprecated: use kSobelwArcgdwInfo_EdgeThresholdInfo
#define kSobelwArcgdwInfo_Threshold1Info kSobelwArcgdwInfo_EdgeThresholdInfo
//kDeprecate(kSobelwArcgdwInfo_Threshold1Info)

//Deprecated: not supported in PL.
kInlineFx(kStatus) kSobelwArcgdwInfo_SetWidthThreshold(kSobelwArcgdwInfo info, k32u threshold)
{
    return kAcgInfo_SetWidthIntensityThreshold(info, threshold);
}
//kDeprecate(kSobelwArcgdwInfo_SetWidthThreshold)

//Deprecated: not supported in PL.
kInlineFx(k32u) kSobelwArcgdwInfo_WidthThreshold(kSobelwArcgdwInfo info)
{
    return kAcgInfo_WidthIntensityThreshold(info);
}
//kDeprecate(kSobelwArcgdwInfo_WidthThreshold)

//Deprecated: not supported in PL.
kInlineFx(kStatus) kSobelwArcgdwInfo_WidthThresholdInfo(kSobelwArcgdwInfo info, kInfo32u* info32u)
{
    return kAcgInfo_WidthIntensityThresholdInfo(info, info32u);
}
//kDeprecate(kSobelwArcgdwInfo_WidthThresholdInfo)

#endif
