/** 
 * @file    kCameraPhaseDecoder.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_PHASE_DECODER_X_H
#define K_FIRESYNC_CAMERA_PHASE_DECODER_X_H

#define kCAMERA_PHASE_DECODER_REF_FRAME_COUNT               (1)

#define kCAMERA_PHASE_DECODER_MIN_STRIPE_COUNT              (1)     //TODO: Set minimum stripe count back to 0 once FSH fixes bug.
#define kCAMERA_PHASE_DECODER_MAX_STRIPE_COUNT              (7)
#define kCAMERA_PHASE_DECODER_DEFAULT_STRIPE_COUNT          (7)

#define kCAMERA_PHASE_DECODER_MIN_STRIPE_THRESHOLD          (0)
#define kCAMERA_PHASE_DECODER_MAX_STRIPE_THRESHOLD          (255)
#define kCAMERA_PHASE_DECODER_DEFAULT_STRIPE_THRESHOLD      (20)

#define kCAMERA_PHASE_DECODER_MIN_PHASE_COUNT               (4)
#define kCAMERA_PHASE_DECODER_MAX_PHASE_COUNT               (10)
#define kCAMERA_PHASE_DECODER_MAX_DELTA_PHASE_COUNT         (7)
#define kCAMERA_PHASE_DECODER_MAX_EPS_PHASE_COUNT           (15)
#define kCAMERA_PHASE_DECODER_DEFAULT_PHASE_COUNT           (6)
#define kCAMERA_PHASE_DECODER_DEFAULT_EPS_PHASE_COUNT       (15)

#define kCAMERA_PHASE_DECODER_MIN_PHASE_SAMPLE_COUNT        (1)
#define kCAMERA_PHASE_DECODER_MAX_PHASE_SAMPLE_COUNT        (65535)
#define kCAMERA_PHASE_DECODER_DEFAULT_PHASE_PERIOD          (400)

#define kCAMERA_PHASE_DECODER_MIN_PHASE_THRESHOLD           (0)
#define kCAMERA_PHASE_DECODER_MAX_PHASE_THRESHOLD           (255)
#define kCAMERA_PHASE_DECODER_DEFAULT_PHASE_THRESHOLD       (20)

#define kCAMERA_PHASE_DECODER_DEFAULT_PHASE_DELTA_BIT_DEPTH (8)

#define kCAMERA_PHASE_DECODER_COMPRESSED_PACKET_SIZE        (4096)

#define kCAMERA_PHASE_DECODER_SUBFRAME_MIN_CAPACITY         (320*1024)   
#define kCAMERA_PHASE_DECODER_SUBFRAME_MAX_CAPACITY         (k16U_MAX*kCAMERA_PHASE_DECODER_SUBFRAME_GRANULARITY)   
#define kCAMERA_PHASE_DECODER_SUBFRAME_GRANULARITY          (4*1024)   

#define kCAMERA_PHASE_DECODER_EPS_MIN_FREQ_CNT              (2u)
#define kCAMERA_PHASE_DECODER_EPS_MAX_FREQ_CNT              (3u)
#define kCAMERA_PHASE_DECODER_EPS_MIN_F1_PHASE_CNT          (3u)
#define kCAMERA_PHASE_DECODER_EPS_MAX_F1_PHASE_CNT          (10u)

#define kCAMERA_PHASE_DECODER_EPS_DEFAULT_F1_PHASE_CNT      (5)

 /* Defaults suitable for DP01 */
#define kCAMERA_PHASE_DECODER_EPS_DEF_EPS_PERIODS           {7u, 49u, 686u}

#define kCAMERA_PHASE_DECODER_PL_SHIFT_MATRIX_COL_COUNT     (16)

#define kCAMERA_PHASE_DECODER_EPS_MAX_PHASE_SHIFT           (16)
#define kCAMERA_PHASE_DECODER_EPS_DEFAULT_SHIFT             (6)

typedef struct kCameraPhaseDecoderClass
{
    kCameraExtClass base; 

    kCameraPhaseDecoderFormat format;
    kSize stripeCount;
    k32u stripeThreshold;
    kSize phaseCount;
    k32u phasePeriod;
    k32u phaseThreshold;
    k32u phasePrediction;
    k32u phaseDeltaBitDepth;
    k32u subframeCount;
    k32u epsFreq1PhaseCount;
    k32u phaseShift;
    kBool epsTransposed;
    kArrayList epsEmbeddedPeriods;
} kCameraPhaseDecoderClass; 

kDeclareClassEx(kFs, kCameraPhaseDecoder, kCameraExt)

/** 
 * Constructs a kCameraPhaseDecoder object.
 *
 * @public              @memberof kCameraPhaseDecoder
 * @param   extension   Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) xkCameraPhaseDecoder_Construct(kCameraPhaseDecoder* extension, kAlloc allocator); 

kFsFx(kStatus) kCameraPhaseDecoder_Init(kCameraPhaseDecoder extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraPhaseDecoder_VRelease(kCameraPhaseDecoder extension); 

kFsFx(kStatus) kCameraPhaseDecoder_VClone(kCameraPhaseDecoder extension, kCameraPhaseDecoder other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraPhaseDecoder_VRead(kCameraPhaseDecoder extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraPhaseDecoder_VWrite(kCameraPhaseDecoder extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraPhaseDecoder_VClear(kCameraPhaseDecoder extension);

kFsFx(kStatus) kCameraPhaseDecoder_VerificationLabel(kCameraPhaseDecoder extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraPhaseDecoder_VVerify(kCameraPhaseDecoder extension);

kFsFx(kSize) kCameraPhaseDecoder_VOutputPortCount(kCameraPhaseDecoder extension); 
kFsFx(kStatus) kCameraPhaseDecoder_VOutputPortInfo(kCameraPhaseDecoder extension, kSize index, kPortInfo* info);  

kFsFx(kBool) kCameraPhaseDecoder_VIsInterruptRequired(kCameraPhaseDecoder extension); 

kFsFx(kCameraFrameAlgType) kCameraPhaseDecoder_LegacyAlgType(kCameraPhaseDecoder extension, k64u frameCount);

kFsFx(kBool) kCameraPhaseDecoder_HasDeltaPhaseDecoder(kCameraPhaseDecoder extension);
kFsFx(kBool) kCameraPhaseDecoder_HasEpsDecoder(kCameraPhaseDecoder extension);
kFsFx(kCameraPhaseDecoderFormat) kCameraPhaseDecoder_DefaultFormat(kCameraPhaseDecoder extension);
kFsFx(kSize) kCameraPhaseDecoder_DefaultStripeCount(kCameraPhaseDecoder extension);
kFsFx(kSize) kCameraPhaseDecoder_DefaultPhaseCount(kCameraPhaseDecoder extension);

kFsFx(kSize) kCameraPhaseDecoder_SubframeCapacity(kCameraPhaseDecoder extension, kSize pixelCount);

kFsFx(kStatus) kCameraPhaseDecoder_FormatEpsLut(kArray2 shiftMatrix, kArray1 plShiftMatrix);

#endif
