/** 
 * @file    kCameraSteps.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_STEPS_X_H
#define K_FIRESYNC_CAMERA_STEPS_X_H

typedef struct kCameraStep
{
    kSize state;            //state index
    kSize count;            //repetition count
} kCameraStep; 

kDeclareValueEx(kFs, kCameraStep, kValue)

typedef struct kCameraStepsClass
{
    kCameraExtClass base; 
    kArrayList steps;           //Step list -- kArrayList<kCameraStep>
    kCameraStepsStyle style;    //Steps style
} kCameraStepsClass; 

kDeclareClassEx(kFs, kCameraSteps, kCameraExt)
        
/** 
 * Constructs a kCameraSteps object.
 *
 * @public                  @memberof kCameraSteps
 * @param   extension       Destination for the constructed object handle. 
 * @param   initialCount    Initial count of steps.
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) xkCameraSteps_Construct(kCameraSteps* extension, kAlloc allocator); 

kFsFx(kStatus) kCameraSteps_Init(kCameraSteps extension, kType type, kSize initialCount, kAlloc alloc); 
kFsFx(kStatus) kCameraSteps_VRelease(kCameraSteps extension); 

kFsFx(kStatus) kCameraSteps_VClone(kCameraSteps extension, kCameraSteps other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraSteps_VRead(kCameraSteps extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraSteps_VWrite(kCameraSteps extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraSteps_VerificationLabel(kCameraSteps extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraSteps_VVerify(kCameraSteps extension); 

kFsFx(kStatus) kCameraSteps_CheckViolations(kCameraSteps extension, kNode node, kChar* label);

kFsFx(kStatus) kCameraSteps_VNextStates(kCameraSteps extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(k64u) kCameraSteps_VMinimumPeriod(kCameraSteps extension); 

kFsFx(kBool) kCameraSteps_VIsInterruptRequired(kCameraSteps extension); 

kFsFx(kCameraStep*) kCameraSteps_StepAt(kCameraSteps extension, kSize index); 

#define kCameraSteps_Count_(S)                  kArrayList_Count(xkCameraSteps_CastRaw(S)->steps)
#define kCameraSteps_RepetitionCount_(S, I)     ((kArrayList_AtT(xkCameraSteps_CastRaw(S)->steps, (I), kCameraStep))->count)
#define kCameraSteps_State_(S, I)               ((kArrayList_AtT(xkCameraSteps_CastRaw(S)->steps, (I), kCameraStep))->state)

#endif
