/** 
 * @file    kLc130xInfo.h
 * @brief   Declares the kLc130xInfo class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC130X_INFO_H
#define K_FIRESYNC_LC130X_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc130xInfo
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC130x camera model. 
 */
//typedef kCameraInfo kLc130xInfo;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLc130xInfo object.
 *
 * @public                  @memberof kLc130xInfo
 * @param   info            Destination for the constructed object handle. 
 * @param   model           Camera model. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kLc130xInfo_Construct(kLc130xInfo* info, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc130xInfo.x.h>

#endif
