/** 
 * @file    kLc150Info.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC150_INFO_X_H
#define K_FIRESYNC_LC150_INFO_X_H

#define kLC150_TOP_BLACK_COL                    (26)
#define kLC150_READOUT_EDGE1                    (416)
#define kLC150_SHUTTER0_EDGE1                   (150)

#define kLC150_MIN_WIDTH                        (8)                 ///< Imager minimum width (pixels).
#define kLC150_MAX_WIDTH                        (2072)              ///< Imager maximum width (pixels).
#define kLC150_WIDTH_GRANULARITY                (8)                 ///< Imager width granularity (pixels).
#define kLC150_MIN_HEIGHT                       (1)                 ///< Imager minimum height (pixels).
#define kLC150_MAX_HEIGHT                       (1)                 ///< Imager maximum height (pixels).
#define kLC150_HEIGHT_GRANULARITY               (1)                 ///< Imager height granularity (pixels).
#define kLC150_LEFT_GRANULARITY                 (8)                 ///< Window x granularity (pixels). 
#define kLC150_TOP_GRANULARITY                  (1)                 ///< Window y granularity (pixels). 

#define kLC150_PRE_EXPOSURE                          (0)                 ///< Lead in (ns).
#define kLC150_POST_EXPOSURE                         (1650)              ///< Lead out (ns).
                                                                    //// kLC150_SHUTTER0_EDGE1/89MHz = 1727 ns

#define kLC150_MIN_EXPOSURE                     (1875)              ///< Minimum exposure (ns).
                                                                    //// kLC150_SHUTTER0_EDGE1/89MHz
#define kLC150_MAX_EXPOSURE                     (1000000000)        ///< Maximum exposure (ns).

#define kLC150_Y_SUB_OPTIONS                    (0x1)               ///< Y-sub choices.

#define kLC150_MAX_IMAGER_X_SUB                 (1)                 ///< Maximum x-subsampling supported by imager.
#define kLC150_MAX_IMAGER_Y_SUB                 (1)                 ///< Maximum y-subsampling supported by imager.
#define kLC150_MIN_BLACK_LEVEL                  (0)                 ///< Minimum black level value.
#define kLC150_MAX_BLACK_LEVEL                  (0)                 ///< Maximum black level value.

#define kLC150_READOUT_ROW_OVERHEAD             (292.3)             ///< Constant readout time per row (ns). 
                                                                    //// kLC150_TOP_BLACK_COL/89MHz

#define kLC150_READOUT_FRAME_OVERHEAD           (4677.3)            ///< Constant readout time per frame (ns). 
                                                                    //// kLC150_READOUT_EDGE1/89MHz

#define kLC150_READOUT_BLANKING_ROWS            (0)                 ///< Hold time after readout, expressed in rows.  
#define kLC150_MIN_INTER_EXPOSURE_GAP           (6000)              ///< Minimum time between end of exposure and start of next exposure (ns). 
#define kLC150_MIN_INTER_READOUT_GAP            (0)                 ///< Minimum time between end of readout and start of next readout (ns).  

#define kLC150_DEFAULT_CENTROID_STEP            (2)                 ///< Range LUT Default CG step
#define kLC150_DEFAULT_VALID_STEP               (2)                 ///< Range LUT Default valid step
#define kLC150_DEFAULT_SLICE_STEP               (1)                 ///< Range LUT Default slice step

typedef struct kLc150InfoClass
{
    kCameraInfoClass base; 
    k32u placeholder;
} kLc150InfoClass; 

kDeclareClassEx(kFs, kLc150Info, kCameraInfo)
        
kFsFx(kStatus) kLc150Info_Init(kLc150Info info, kType type, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kLc150Info_VRelease(kLc150Info info);

kFsFx(k64f) kLc150Info_ReadoutTime(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VReadoutTime(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VMinInterExposureGap(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VMinInterReadoutGap(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VMinExposure(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VMaxExposure(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VPreExposure(kLc150Info info, const kCameraInfoParams* params);
kFsFx(k64f) kLc150Info_VPostExposure(kLc150Info info, const kCameraInfoParams* params);

#endif
