/** 
 * @file    kLc200xInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC200X_INFO_X_H
#define K_FIRESYNC_LC200X_INFO_X_H

#define kLC200X_MIN_WIDTH                           (32)                ///< Imager minimum width (pixels).
#define kLC200X_MAX_WIDTH                           (1984)              ///< Imager maximum width (pixels).
#define kLC200X_WIDTH_GRANULARITY                   (16)                ///< Imager width granularity based on kernel size (pixels).
#define kLC200X_MIN_HEIGHT                          (2)                 ///< Imager minimum height (pixels).
#define kLC200X_MAX_HEIGHT                          (1264)              ///< Imager maximum height (pixels).
#define kLC200X_RLUT_WIDTH                          (1280)              ///< Range LUT width (TODO: FSS-360, FSS-384).
#define kLC200X_RLUT_HEIGHT                         (1984)              ///< Range LUT height (TODO: FSS-360, FSS-384).
#define kLC200X_HEIGHT_GRANULARITY                  (2)                 ///< Imager height granularity (pixels).
#define kLC200X_LEFT_GRANULARITY                    (16)                ///< Window x granularity (pixels). 
#define kLC200X_TOP_GRANULARITY                     (2)                 ///< Window y granularity (pixels). 
#define kLC200X_PRE_EXPOSURE                             (538)               ///< Lead in (pixel periods).
#define kLC200X_POST_EXPOSURE                            (6654)              ///< Lead out (pixel periods).
#define kLC200X_MIN_EXPOSURE                        (7021)              ///< Minimum exposure (pixel periods).
#define kLC200X_MAX_EXPOSURE                        (1000000000)        ///< Maximum exposure (ns).
#define kLC2000_MAX_IMAGER_X_SUB                    (2)                 ///< Maximum x-subsampling supported by imager.
#define kLC2001_MAX_IMAGER_X_SUB                    (1)                 ///< Maximum x-subsampling supported by imager.
#define kLC200X_MAX_IMAGER_Y_SUB                    (2)                 ///< Maximum y-subsampling supported by imager.
#define kLC200X_IMAGER_X_SUB_OPTIONS                (3)                 ///< X-subsampling options supported by imager.
#define kLC200X_IMAGER_Y_SUB_OPTIONS                (3)                 ///< Y-subsampling options supported by imager.
#define kLC200X_DIGITAL_GAIN_GRANULARITY            (0.0078125)         ///< Digital gain step granularity.
#define kLC200X_DIGITAL_GAIN_MAX_STEP               (3968)              ///< Maximum digital gain step.
#define kLC200X_MIN_BLACK_LEVEL                     (0)                 ///< Minimum black level value.
#define kLC200X_MAX_BLACK_LEVEL                     (0xFF)              ///< Maximum black level value.
#define kLC200X_MIN_KNEE_COUNT                      (0)                 ///< Multi-Slope minimum knee count
#define kLC200X_MAX_KNEE_COUNT                      (2)                 ///< Multi-Slope minimum knee count
#define kLC200X_KNEE_COUNT_GRANULARITY              (1)                 ///< Multi-Slope knee count granularity

#define kLC200X_MIN_INTER_READOUT_GAP               (0)                 ///< Minimum time between end of readout and start of next readout (ns).  

#define kLC200X_DEFAULT_CENTROID_STEP_8K            (32)                ///< Range LUT Default CG step (8K entries)
#define kLC200X_DEFAULT_CENTROID_STEP_16K           (16)                ///< Range LUT Default CG step (16K entries)
#define kLC200X_DEFAULT_VALID_STEP                  (8)                 ///< Range LUT Default valid step
#define kLC200X_DEFAULT_SLICE_STEP                  (16)                ///< Range LUT Default slice step

/* 
 * register set constants -- refer to imager driver, datasheets, appnotes and characterization document.
 */

#define kLC200X_ROT_IMG_BL_SINGLE_SLOPE             (272)               ///< Single slope ROT length (pixel periods: ~68*4)
#define kLC200X_XSM_DELAY_SINGLE_SLOPE              (0)                 ///< Single slope XSM delay (pixel periods: 0*4)
#define kLC200X_ROT_IMG_BL_MULTI_SLOPE              (392)               ///< Multi slope ROT length (pixel periods: ~98*4)
#define kLC200X_XSM_DELAY_MULTI_SLOPE               (320)               ///< Multi slope XSM delay (pixel periods: 80*4)

#define kLC200X_FOT_SINGLE_SLOPE                    (11000)             ///< Single slope FOT length (pixel periods)
#define kLC200X_FOT_MULTI_SLOPE                     (20352)             ///< Multi slope FOT length (pixel periods)

#define kLC200X_MIN_INTER_KNEE_GAP_0                (0)                 ///< Multi slope minimum inter knee gap 0
#define kLC200X_MIN_INTER_KNEE_GAP_1                (12544)             ///< Multi slope minimum inter knee gap 1 (FOT_DS*4: 3136*4)
#define kLC200X_MIN_INTER_KNEE_GAP_2                (1280)              ///< Multi slope minimum inter knee gap 2 (FOT_TS*4: 320*4)

typedef struct kLc200xInfoClass
{
    kCameraInfoClass base; 
    k32u placeholder;
} kLc200xInfoClass; 

kDeclareClassEx(kFs, kLc200xInfo, kCameraInfo)
        
kFsFx(kStatus) kLc200xInfo_Init(kLc200xInfo info, kType type, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kLc200xInfo_VRelease(kLc200xInfo info);

kFsFx(kBool) kLc200xInfo_VHasGainChannel(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc200xInfo_VMaxGainStep(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc200xInfo_VGainStep(kLc200xInfo info, kCameraGain channel, k64f gain);
kFsFx(k64f) kLc200xInfo_VGainFactor(kLc200xInfo info, kCameraGain channel, k32u index);

kFsFx(k32u) kLc200xInfo_DigitalGainStep(kLc200xInfo info, k64f gain);
kFsFx(k64f) kLc200xInfo_DigitalGainFactor(kLc200xInfo info, k32u index);
kFsFx(k32u) kLc200xInfo_ColorGainStep(kLc200xInfo info, k64f gain);
kFsFx(k64f) kLc200xInfo_ColorGainFactor(kLc200xInfo info, k32u index);

kFsFx(k64f) kLc200xInfo_FrameOverheadTime(kLc200xInfo info, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc200xInfo_RowTime(kLc200xInfo info, k32u pixelCount, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc200xInfo_MinInterKneeGap(kLc200xInfo info, kSize slopeIndex, k64f pixelPeriod);
kFsFx(k64f) kLc200xInfo_MinGammaExposure(kLc200xInfo info, k64f pixelPeriod, const kPoint64f* kneePoints, kSize kneeCount);

kFsFx(k64f) kLc200xInfo_ReadoutTime(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VReadoutTime(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VMinInterExposureGap(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VMinInterReadoutGap(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VMinExposure(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VMaxExposure(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VPreExposure(kLc200xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc200xInfo_VPostExposure(kLc200xInfo info, const kCameraInfoParams* params);

#endif
