/** 
 * @file    kLc250xInfo.h
 * @brief   Declares the kLc250xInfo class and related types. 
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC250X_INFO_H
#define K_FIRESYNC_LC250X_INFO_H

#include <kFireSync/Client/Camera/kCameraInfo.h>

/**
 * @internal
 * @class   kLc250xInfo
 * @extends kCameraInfo
 * @ingroup kFireSync-Client-Camera
 * @brief   Represents information about the LC250x camera model. 
 */
//typedef kCameraInfo kLc250xInfo;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLc250xInfo object.
 *
 * @public                  @memberof kLc250xInfo
 * @param   info            Destination for the constructed object handle. 
 * @param   capabilities    Camera algorithm capabilities. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kLc250xInfo_Construct(kLc250xInfo* info, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc allocator);

#include <kFireSync/Client/Camera/kLc250xInfo.x.h>

#endif
