/** 
 * @file    kLc65xInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC65X_INFO_X_H
#define K_FIRESYNC_LC65X_INFO_X_H

#define kLC65X_MIN_WIDTH                        (16)                ///< Imager minimum width (pixels).
#define kLC65X_MAX_WIDTH                        (1280)              ///< Imager maximum width (pixels).
#define kLC65X_WIDTH_GRANULARITY                (8)                 ///< Imager width granularity based on kernel size (pixels).
#define kLC65X_MIN_HEIGHT                       (2)                 ///< Imager minimum height (pixels).
#define kLC65X_MAX_HEIGHT                       (1024)              ///< Imager maximum height (pixels).
#define kLC65X_HEIGHT_GRANULARITY               (2)                 ///< Imager height granularity (pixels).
#define kLC65X_LEFT_GRANULARITY                 (8)                 ///< Window x granularity (pixels). 
#define kLC65X_TOP_GRANULARITY                  (2)                 ///< Window y granularity (pixels). 
#define kLC65X_PRE_EXPOSURE                          (0)                 ///< Lead in (ns).
#define kLC65X_POST_EXPOSURE                         (15500)             ///< Lead out (ns).
#define kLC65X_MIN_EXPOSURE                     (16500)             ///< Minimum exposure (ns).
#define kLC65X_MAX_EXPOSURE                     (1000000000)        ///< Maximum exposure (ns).
#define kLC65X_MAX_IMAGER_X_SUB                 (2)                 ///< Maximum x-subsampling supported by imager.
#define kLC65X_MAX_IMAGER_Y_SUB                 (2)                 ///< Maximum y-subsampling supported by imager.
#define kLC65X_DIGITAL_GAIN_GRANULARITY         (0.0078125)         ///< Digital gain step granularity.
#define kLC65X_DIGITAL_GAIN_MAX_STEP            (3968)              ///< Maximum digital gain step.
#define kLC65X_MIN_BLACK_LEVEL                  (0)                 ///< Minimum black level value.
#define kLC65X_MAX_BLACK_LEVEL                  (0xFF)              ///< Maximum black level value.
#define kLC65X_MIN_KNEE_COUNT                   (0)                 ///< Multi-Slope minimum knee count
#define kLC65X_MAX_KNEE_COUNT                   (2)                 ///< Multi-Slope minimum knee count
#define kLC65X_KNEE_COUNT_GRANULARITY           (1)                 ///< Multi-Slope knee count granularity
#define kLC65X_READOUT_ROW_OVERHEAD             (1375.1)            ///< Constant readout time per row (ns). 
#define kLC65X_READOUT_FRAME_OVERHEAD           (30575.1)           ///< Constant readout time per frame (ns). 
#define kLC65X_READOUT_GAMMA_FRAME_OVERHEAD     (30575.1 + 30000.0) ///< Constant readout time per frame (ns). 
#define kLC65X_READOUT_BLANKING_ROWS            (1)                 ///< Hold time after readout, expressed in rows.  
#define kLC65X_MIN_NOMINAL_INTER_EXPOSURE_GAP   (23247.6)           ///< Minimum time between end of exposure and start of next exposure without sequencing (ns).
#define kLC65X_MIN_SEQUENCED_INTER_EXPOSURE_GAP (30575.1)           ///< Minimum time between end of exposure and start of next exposure with sequencing (ns).
#define kLC65X_MIN_INTER_READOUT_GAP            (0)                 ///< Minimum time between end of readout and start of next readout (ns).  

#define kLC65X_DEFAULT_CENTROID_STEP_8K         (32)                ///< Range LUT Default CG step (8K entries)
#define kLC65X_DEFAULT_CENTROID_STEP_16K        (16)                ///< Range LUT Default CG step (16K entries)
#define kLC65X_DEFAULT_VALID_STEP               (8)                 ///< Range LUT Default valid step
#define kLC65X_DEFAULT_SLICE_STEP               (8)                 ///< Range LUT Default slice step

typedef struct kLc65xInfoClass
{
    kCameraInfoClass base; 

    kArrayList analogFactors;

} kLc65xInfoClass; 

kDeclareClassEx(kFs, kLc65xInfo, kCameraInfo)
        
kFsFx(kStatus) kLc65xInfo_Init(kLc65xInfo info, kType type, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kLc65xInfo_VRelease(kLc65xInfo info);

kFsFx(kBool) kLc65xInfo_VHasGainChannel(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc65xInfo_VMaxGainStep(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc65xInfo_VGainStep(kLc65xInfo info, kCameraGain channel, k64f gain);
kFsFx(k64f) kLc65xInfo_VGainFactor(kLc65xInfo info, kCameraGain channel, k32u index);

kFsFx(k32u) kLc65xInfo_AnalogGainStep(kLc65xInfo info, k64f gain);
kFsFx(k64f) kLc65xInfo_AnalogGainFactor(kLc65xInfo info, k32u index);
kFsFx(k32u) kLc65xInfo_DigitalGainStep(kLc65xInfo info, k64f gain);
kFsFx(k64f) kLc65xInfo_DigitalGainFactor(kLc65xInfo info, k32u index);

kFsFx(kStatus) kLc65xInfo_ComposeAnalogGain(kLc65xInfo info);

kFsFx(k64f) kLc65xInfo_ReadoutTime(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VReadoutTime(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VMinInterExposureGap(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VMinInterReadoutGap(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VMinExposure(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VMaxExposure(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VPreExposure(kLc65xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc65xInfo_VPostExposure(kLc65xInfo info, const kCameraInfoParams* params);

#endif
