/** 
 * @file    kControl5Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CONTROL_5_CLIENT_X_H
#define K_FIRESYNC_CONTROL_5_CLIENT_X_H

#include <kApi/Io/kUdpClient.h>

#define kCONTROL_5_CLIENT_CLIENT_READ_BUFFER                        (1536)
#define kCONTROL_5_CLIENT_CLIENT_WRITE_BUFFER                       (1536)
#define kCONTROL_5_CLIENT_SOCK_TIMEOUT                              (50000)
#define kCONTROL_5_CLIENT_RETRANSMIT_COUNT                          (5)
#define kCONTROL_5_CLIENT_REPLY_READ_COUNT                          (10)
#define kCONTROL_5_CLIENT_FLASH_TIMEOUT                             (50000000)
#define kCONTROL_5_CLIENT_FLASH_POLL                                (100000)

#define kCONTROL_5_CLIENT_NODE_PORT                                 (2003)      // kETHERNET_SERVICES_RECEIVE_PORT
#define kCONTROL_5_CLIENT_PROTOCOL_ID                               (0x10)      // kETHERNET_PROT_REQUEST_V6

typedef k32s kControl5ClientFirmware;
#define kCONTROL_5_CLIENT_FIRMWARE_TYPE_BOOT_LOADER                 (0)         // kFLASH_SEG_BOOTLOADER
#define kCONTROL_5_CLIENT_FIRMWARE_TYPE_MAIN_SOFTWARE_PROGRAM       (3)         // kFLASH_SEG_DSP
#define kCONTROL_5_CLIENT_FIRMWARE_TYPE_RESCUE_SOFTWARE_PROGRAM     (6)         // kFLASH_SEG_DSP_BACKUP
#define kCONTROL_5_CLIENT_FIRMWARE_TYPE_MAIN_PL_PROGRAM             (2)         // kFLASH_SEG_FPGA
#define kCONTROL_5_CLIENT_FIRMWARE_TYPE_SECONDARY_PL_PROGRAM        (5)         // kFLASH_SEG_EXT_FPGA

#define kCONTROL_5_CLIENT_REQUEST_DIRECTION_GET                     (0)         // kREQUEST_DIRECTION_GET
#define kCONTROL_5_CLIENT_REQUEST_DIRECTION_SET                     (1)         // kREQUEST_DIRECTION_SET

#define kCONTROL_5_CLIENT_REQUEST_CMD_SHIFT                         (0)         // kREQUEST_CMD_SHIFT
#define kCONTROL_5_CLIENT_REQUEST_CMD_MASK                          (0xFFFF)    // kREQUEST_CMD_MASK

#define kCONTROL_5_CLIENT_REQUEST_DIRECTION_SHIFT                   (16)        // kCONTROL_5_CLIENT_REQUEST_DIRECTION_SHIFT
#define kCONTROL_5_CLIENT_REQUEST_DIRECTION_MASK                    (0xFF)      // kCONTROL_5_CLIENT_REQUEST_DIRECTION_MASK

#define kCONTROL_5_CLIENT_REQUEST_CONNECT_LOCK_SHIFT                (24)        // kREQUEST_CONNECT_LOCK_SHIFT
#define kCONTROL_5_CLIENT_REQUEST_CONNECT_LOCK_MASK                 (0xFF)      // kREQUEST_CONNECT_LOCK_MASK

#define kCONTROL_5_CLIENT_MODULE_IDX_SHIFT                          (32)        // kCONTROL_5_CLIENT_MODULE_IDX_SHIFT
#define kCONTROL_5_CLIENT_MODULE_IDX_MASK                           (0xFF)      // kCONTROL_5_CLIENT_MODULE_IDX_MASK

#define kCONTROL_5_CLIENT_MODULE_SHIFT                              (40)        // kCONTROL_5_CLIENT_MODULE_SHIFT
#define kCONTROL_5_CLIENT_MODULE_MASK                               (0xFF)      // kCONTROL_5_CLIENT_MODULE_MASK

#define kCONTROL_5_CLIENT_REQUEST_WRAPPER_SHIFT                     (48)        // kREQUEST_WRAPPER_SHIFT
#define kCONTROL_5_CLIENT_REQUEST_WRAPPER_MASK                      (0xFF)      // kREQUEST_WRAPPER_MASK

#define kCONTROL_5_CLIENT_MODULE_DUMMY                              (0x00)      // kREQUEST_MODULE_DUMMY
#define kCONTROL_5_CLIENT_MODULE_SENSOR                             (0x01)      // kREQUEST_MODULE_SENSOR
#define kCONTROL_5_CLIENT_MODULE_CAMERA                             (0x02)      // kREQUEST_MODULE_CAMERA
#define kCONTROL_5_CLIENT_MODULE_PIPE                               (0x03)      // kREQUEST_MODULE_PIPE
#define kCONTROL_5_CLIENT_MODULE_LIGHT                              (0x04)      // kREQUEST_MODULE_LIGHT
#define kCONTROL_5_CLIENT_MODULE_SERVER                             (0x05)      // kREQUEST_MODULE_SERVER
#define kCONTROL_5_CLIENT_MODULE_ENCODER                            (0x06)      // kREQUEST_MODULE_ENCODER
#define kCONTROL_5_CLIENT_MODULE_PROJECTOR                          (0x07)      // kREQUEST_MODULE_PROJECTOR
#define kCONTROL_5_CLIENT_MODULE_STORAGE                            (0x08)      // kREQUEST_MODULE_STORAGE
#define kCONTROL_5_CLIENT_MODULE_DEBUG                              (0x0A)      // kREQUEST_MODULE_DEBUG
#define kCONTROL_5_CLIENT_MODULE_STROBE                             (0x0C)      // kREQUEST_MODULE_STROBE
#define kCONTROL_5_CLIENT_MODULE_CONNECT                            (0x0E)      // kREQUEST_MODULE_CONNECT

#define kCONTROL_5_CLIENT_DEVICE_ID_SERIAL_MASK                     (0x00FFFFFF)// kDEVICEID_SERIAL_MASK
#define kCONTROL_5_CLIENT_DEVICE_ID_SERIAL_SHIFT                    (0)         // kDEVICEID_SERIAL_SHIFT

#define kCONTROL_5_CLIENT_DEVICE_ID_LOCATION_MASK                   (0x1)       // kDEVICEID_LOCATION_MASK
#define kCONTROL_5_CLIENT_DEVICE_ID_LOCATION_SHIFT                  (24)        // kDEVICEID_LOCATION_SHIFT

#define kCONTROL_5_CLIENT_DEVICE_ID_LOCATION_REMOTE                 (0x0)       // kDEVICEID_LOCATION_REMOTE
#define kCONTROL_5_CLIENT_DEVICE_ID_LOCATION_LOCAL                  (0x1)       // kDEVICEID_LOCATION_LOCAL

#define kCONTROL_5_CLIENT_DEVICE_ID_TYPE_MASK                       (0xF)       // kDEVICEID_TYPE_MASK
#define kCONTROL_5_CLIENT_DEVICE_ID_TYPE_SHIFT                      (28)        // kDEVICEID_TYPE_SHIFT

#define kCONTROL_5_CLIENT_NODE_TYPE_SENSOR                          (0x05)      // kDEVICEID_TYPE_SENSOR
#define kCONTROL_5_CLIENT_NODE_TYPE_MASTER                          (0x08)      // kDEVICEID_TYPE_MASTER

#define kCONTROL_5_CLIENT_SENSOR_GET_NODE_INFO                      (244)       // kSENSOR_ATTR_HARDWARE
#define kCONTROL_5_CLIENT_SENSOR_NODE_INFO_TYPE_M50                 (6)         // kFIRESYNC_HARDWARE_M50
#define kCONTROL_5_CLIENT_SENSOR_NODE_INFO_TYPE_M2                  (7)         // kFIRESYNC_HARDWARE_M2

#define kCONTROL_5_CLIENT_SENSOR_PROT_VERSION                       (249)       // kSENSOR_ATTR_PROT_VERSION
#define kCONTROL_5_CLIENT_SENSOR_FLASH_REQ                          (250)       // kSENSOR_FLASH_REQ    
#define kCONTROL_5_CLIENT_SENSOR_CMD_READY                          (1017)      // kSENSOR_CMD_READY

#define kCONTROL_5_CLIENT_FLASH_OPERATION_RESET                     (15)        // kFLASH_REQUEST_RESET
#define kCONTROL_5_CLIENT_FLASH_OPERATION_BUFFERED_WRITE_HEADER     (16)        // kFLASH_REQUEST_BUFFERED_WRITE_HEADER
#define kCONTROL_5_CLIENT_FLASH_OPERATION_BUFFERED_WRITE_DATA       (17)        // kFLASH_REQUEST_BUFFERED_WRITE_DATA
#define kCONTROL_5_CLIENT_FLASH_OPERATION_BUFFERED_WRITE_END        (18)        // kFLASH_REQUEST_BUFFERED_WRITE_END

#define kCONTROL_5_CLIENT_FLASH_REQUEST_BUFFER_SIZE                 (256)       // kFLASH_REQUEST_BUFFER_SIZE

typedef struct kControl5ClientClass
{
    kObjectClass base; 

    kUdpClient client; 
    kSerializer serializer; 

    k32u packetIndex;
    k32u lastPacketId;

    k32u id;
    kIpAddress address;

} kControl5ClientClass; 

kDeclareClassEx(kFs, kControl5Client, kObject)
        
kFsFx(kStatus) kControl5Client_Init(kControl5Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kControl5Client_VRelease(kControl5Client client); 

kFsFx(kStatus) kControl5Client_Sync(kControl6Client client);
kFsFx(kStatus) kControl5Client_WriteBufferedHeader(kControl6Client client, kSize size, kControl5ClientFirmware firmware);
kFsFx(kStatus) kControl5Client_WriteBufferedData(kControl6Client client, const kByte* buffer, kSize size, kControl5ClientFirmware firmware);
kFsFx(kStatus) kControl5Client_EndBufferedWrite(kControl6Client client, k32u checksum, kSize size, kControl5ClientFirmware firmware);
kFsFx(kStatus) kControl5Client_IsReady(kControl6Client client, kBool* isReady);

kFsFx(kStatus) kControl5Client_BeginWriteCommand(kControl5Client client, kSize dataSize, k64u requestId);
kFsFx(kStatus) kControl5Client_SendAndReceive(kControl5Client client); 

kFsFx(kStatus) kControl5Client_WaitReady(kControl6Client client, k64u timeout);
kFsFx(kStatus) kControl5Client_FirmwareType(kControl5Client client, kNodeFirmwareType nodeFirmware, kControl5ClientFirmware* firmware);

kFsFx(k32u) kControl5Client_DeviceIdCompose(k32u serial, k32u location, k32u type);
kFsFx(k32u) kControl5Client_DeviceIdLocalSensor(k32u serial);

kFsFx(k64u) kControl5Client_RequestCompose(k64u command, k64u direction, k64u moduleIndex, k64u moduleType, k64u wrapperType);
kFsFx(k64u) kControl5Client_RequestSensor(k64u command, kBool isGet);

kFsFx(void) kControl5Client_UpdateProgress(kCallbackFx progress, kPointer context, k32u progressValue);

#endif
