/** 
 * @file    kHealth6Client.h
 * @brief   Declares the kHealth6Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_6_CLIENT_H
#define K_FIRESYNC_HEALTH_6_CLIENT_H

#include <kFireSync/kNodeDef.h>

/**
 * @internal
 * @class   kHealth6Client
 * @extends kObject
 * @ingroup kFireSync-Client-Network
 * @brief   Implements an FHSP-6 client. 
 */
//typedef kObject kHealth6Client;            --forward-declared in kFsDef.x.h

/** 
 * Constructs a kHealth6Client object.
 *
 * @public              @memberof kHealth6Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kHealth6Client_Construct(kHealth6Client* client, kAlloc allocator); 

kFsFx(kStatus) kHealth6Client_SetMessageAlloc(kHealth6Client client, kAlloc alloc);

kFsFx(kStatus) kHealth6Client_SetReceiveHandler(kHealth6Client client, kCallbackFx function, kPointer receiver);

kFsFx(kStatus) kHealth6Client_BeginOpen(kHealth6Client client, kIpAddress ipAddress, k32u ipPort); 
kFsFx(kStatus) kHealth6Client_EndOpen(kHealth6Client client); 

kFsFx(kStatus) kHealth6Client_Close(kHealth6Client client); 

#include <kFireSync/Client/Network/kHealth6Client.x.h>

#endif
