/** 
 * @file    kNodeProvider.h
 * @brief   Declares the kNodeProvider interface. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_NODE_PROVIDER_H
#define K_FIRESYNC_NODE_PROVIDER_H

#include <kFireSync/kNodeDef.h>
#include <kApi/Io/kStream.h>

/**
 * @internal
 * @interface   kNodeProvider
 * @ingroup     kFireSync-Client-Network
 * @brief       Represents a connection to a sensor device. 
 */
//typedef kObject kNodeProvider;            --forward-declared in kFsDef.x.h  

//thread-safe

kFsFx(kBool) kNodeProvider_IsRemote(kNodeProvider provider); 

kFsFx(kStatus) kNodeProvider_SetErrorHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver); 
kFsFx(kStatus) kNodeProvider_SetCancelHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver); 
kFsFx(kStatus) kNodeProvider_SetProtocolVersion(kNodeProvider provider, kVersion protocol, kVersion platform); 
kFsFx(kStatus) kNodeProvider_BeginOpenControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_EndOpenControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_CloseControl(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_SetHealthHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver);
kFsFx(kStatus) kNodeProvider_BeginOpenHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_EndOpenHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_CloseHealth(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_SetDataBufferSize(kNodeProvider provider, kSize size);
kFsFx(kStatus) kNodeProvider_SetDataHandler(kNodeProvider provider, kCallbackFx function, kPointer receiver);
kFsFx(kStatus) kNodeProvider_BeginOpenData(kNodeProvider provider, const k16u* ports, kSize portCount); 
kFsFx(kStatus) kNodeProvider_EndOpenData(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_EndDataSession(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_CloseData(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_InvalidateDataSession(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_ClearFirmware(kNodeProvider provider, kNodeFirmwareType type); 
kFsFx(kStatus) kNodeProvider_WriteFirmware(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_ReloadFirmware(kNodeProvider provider, kNodeFirmwareType type, kStream stream, kSize size);
kFsFx(kStatus) kNodeProvider_Reset(kNodeProvider provider, kBool restartApp);

kFsFx(kStatus) kNodeProvider_ChangeAddressAndReset(kNodeProvider provider, kSize nodeInterfaceIndex, const kIpConfig* config); 

kFsFx(kStatus) kNodeProvider_WriteFile(kNodeProvider provider, const kChar* path, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_CopyFile(kNodeProvider provider, const kChar* sourcePath, const kChar* destPath, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_ReadFile(kNodeProvider provider, const kChar* path, kStream stream, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNodeProvider_DeleteFile(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_GetFileInfo(kNodeProvider provider, const kChar* path, kStorageItem* item);
kFsFx(kStatus) kNodeProvider_CreateDirectory(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_DeleteDirectory(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_ListDirectoryEntries(kNodeProvider provider, const kChar* path, kBool includeFiles, kBool includeDirectories, kArrayList entries); 
kFsFx(kStatus) kNodeProvider_ListDirectoryEntriesEx(kNodeProvider provider, const kChar* path, kArrayList entries); 

kFsFx(kStatus) kNodeProvider_SetDeviceConfig(kNodeProvider provider, kXml xml, k64u revisionId); 
kFsFx(kStatus) kNodeProvider_GetDeviceConfig(kNodeProvider provider, kXml xml, k64u* revisionId); 
kFsFx(kStatus) kNodeProvider_CommitDeviceConfig(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_SetModeConfig(kNodeProvider provider, kXml xml, k64u revisionId); 
kFsFx(kStatus) kNodeProvider_GetModeConfig(kNodeProvider provider, kXml xml, k64u* revisionId); 
kFsFx(kStatus) kNodeProvider_SaveModeConfig(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_LoadModeConfig(kNodeProvider provider, const kChar* path); 
kFsFx(kStatus) kNodeProvider_CommitModeConfig(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_ValidateBlockConfig(kNodeProvider provider, kXml xml);    
kFsFx(kStatus) kNodeProvider_SetDateTime(kNodeProvider provider, kDateTime dateTime, kBool isAuthoritative); 
kFsFx(kStatus) kNodeProvider_IncrementInputCounter(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_ListProcedures(kNodeProvider provider, kArrayList procedures);    
kFsFx(kStatus) kNodeProvider_InvokeProcedure(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc);    

kFsFx(kStatus) kNodeProvider_SetVariable(kNodeProvider provider, const kChar* name, kObject variable); 
kFsFx(kStatus) kNodeProvider_GetVariable(kNodeProvider provider, const kChar* name, kObject* variable, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_GetVariableInfo(kNodeProvider provider, const kChar* name, kNodeVariableInfo* info); 
kFsFx(kStatus) kNodeProvider_DeleteVariable(kNodeProvider provider, const kChar* name); 
kFsFx(kStatus) kNodeProvider_ListVariables(kNodeProvider provider, kArrayList variables); 

kFsFx(kStatus) kNodeProvider_ValidateActionConfig(kNodeProvider provider, kXml config); 
kFsFx(kStatus) kNodeProvider_InvokeAction(kNodeProvider provider, const kChar* typeName, kXml config, kObject input, kObject* output, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_InvokeNamedAction(kNodeProvider provider, const kChar* name, kObject input, kObject* output, kAlloc alloc); 

kFsFx(kStatus) kNodeProvider_ReadMemory(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, void* data);
kFsFx(kStatus) kNodeProvider_WriteMemory(kNodeProvider provider, kNodeMemorySpace space, k64u offset, kSize length, const void* data);

kFsFx(kStatus) kNodeProvider_ReadRegisters(kNodeProvider provider, kRegisterModule moduleType, kSize moduleIndex, kArrayList registers);
kFsFx(kStatus) kNodeProvider_ReadRegisterOverrides(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers);
kFsFx(kStatus) kNodeProvider_WriteRegisterOverrides(kNodeProvider provider, kRegisterModule moduleType, kArrayList registers);

kFsFx(kStatus) kNodeProvider_I2cRead(kNodeProvider provider, k32u deviceId, k32u address, kByte* data, kSize size);
kFsFx(kStatus) kNodeProvider_I2cWrite(kNodeProvider provider, k32u deviceId, k32u address, const kByte* data, kSize size);

kFsFx(kStatus) kNodeProvider_BeginSpi(kNodeProvider provider, kSpiDeviceType type);
kFsFx(kStatus) kNodeProvider_EndSpi(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_SpiRead(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);
kFsFx(kStatus) kNodeProvider_SpiWrite(kNodeProvider provider, kByte* opCode, kSize opSize, kByte* data, kSize dataSize);

kFsFx(kStatus) kNodeProvider_ReadLogHistory(kNodeProvider provider, kArrayList logItems);
kFsFx(kStatus) kNodeProvider_ReadCrashLog(kNodeProvider provider, kString* crashLog, kAlloc allocator);
kFsFx(kStatus) kNodeProvider_ClearCrashLog(kNodeProvider provider);

kFsFx(kStatus) kNodeProvider_BeginStart(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_EndStart(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_BeginStop(kNodeProvider provider, kBool synchronizeData); 
kFsFx(kStatus) kNodeProvider_EndStop(kNodeProvider provider); 
kFsFx(kStatus) kNodeProvider_BeginEngage(kNodeProvider provider, k64u startTime, k64s startEncoder); 
kFsFx(kStatus) kNodeProvider_EndEngage(kNodeProvider provider); 

kFsFx(kStatus) kNodeProvider_BeginStartReplay(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_EndStartReplay(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_Replay(kNodeProvider provider, kObject input, kArrayList output);

kFsFx(kStatus) kNodeProvider_CameraOverride(kNodeProvider provider, kSize index, const kCameraOverrideItem* overrides, kSize count);
kFsFx(kStatus) kNodeProvider_LightOverride(kNodeProvider provider, kSize index, const kLightOverrideItem* overrides, kSize count);

kFsFx(kStatus) kNodeProvider_ScheduleEvent(kNodeProvider provider, k32u eventManagerId, k64s target);    
kFsFx(kStatus) kNodeProvider_TriggerEvent(kNodeProvider provider, k32u eventManagerId); 
kFsFx(kStatus) kNodeProvider_WriteRamImage(kNodeProvider provider, kSize index, kSize stateIndex, kSize imageIndex, kImage image);
kFsFx(kStatus) kNodeProvider_WritePrnu(kNodeProvider provider, kSize index, kImage white, kImage black);
kFsFx(kStatus) kNodeProvider_WriteFpn(kNodeProvider provider, kSize index, kImage offsets);
kFsFx(kStatus) kNodeProvider_WriteRangeLut(kNodeProvider provider, kSize index, const kRangeLutParams* params, const kRangeLutArray* xArray,
                                           const kRangeLutArray* zArray, const kRangeLutArray* validArray);
kFsFx(kStatus) kNodeProvider_WritePhaseDecoderLut(kNodeProvider provider, kSize index, kCameraPhaseDecoderLutType type, kArray1 lut);
kFsFx(kStatus) kNodeProvider_SetCameraLvdsPower(kNodeProvider provider, kSize index, k32u power);
kFsFx(kStatus) kNodeProvider_GetCameraLvdsPower(kNodeProvider provider, kSize index, k32u* power);
kFsFx(kStatus) kNodeProvider_WriteAccelerationTestData(kNodeProvider provider, kSize index, kObject data);
kFsFx(kStatus) kNodeProvider_ReadAccelerationTestResult(kNodeProvider provider, kSize index, kObject* data, kAlloc allocator);
kFsFx(kStatus) kNodeProvider_TriggerCamera(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_TriggerLight(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_SetLightState(kNodeProvider provider, kSize index, kBool enabled);
kFsFx(kStatus) kNodeProvider_LoadPatterns(kNodeProvider provider, kSize index, kArray2 patterns);
kFsFx(kStatus) kNodeProvider_LoadProjectorRowGains(kNodeProvider provider, kSize index, kArray1 gains);
kFsFx(kStatus) kNodeProvider_LoadProjectorColGains(kNodeProvider provider, kSize index, kArray1 gains);
kFsFx(kStatus) kNodeProvider_SetDigitalOutState(kNodeProvider provider, kSize index, kBool state);
kFsFx(kStatus) kNodeProvider_TriggerDigitalOut(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_EnqueueAnalogOut(kNodeProvider provider, kSize index, k32u value);
kFsFx(kStatus) kNodeProvider_EnqueueAnalogOutCurrent(kNodeProvider provider, kSize index, k64f current);
kFsFx(kStatus) kNodeProvider_WriteAnalogOutCalibration(kNodeProvider provider, kSize index, kArray2 calibration, k64u revisionId);
kFsFx(kStatus) kNodeProvider_WriteSerialOut(kNodeProvider provider, kSize index, const void* buffer, kSize size);
kFsFx(kStatus) kNodeProvider_ResetEncoder(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_EnableLed(kNodeProvider provider, kLed instance, kBool enabled);
kFsFx(kStatus) kNodeProvider_SetLedMode(kNodeProvider provider, kLed instance, kLedMode mode);
kFsFx(kStatus) kNodeProvider_SetGpioState(kNodeProvider provider, kSize bankIndex, k64u mask, k64u state);
kFsFx(kStatus) kNodeProvider_GetGpioState(kNodeProvider provider, kSize bankIndex, k64u* state);

kFsFx(kStatus) kNodeProvider_GetInfo(kNodeProvider provider, kNodeInfo* info); 
kFsFx(kStatus) kNodeProvider_GetState(kNodeProvider provider, kNodeStateInfo* info); 
kFsFx(kStatus) kNodeProvider_GetHealth(kNodeProvider provider, kArrayList stats); 
kFsFx(kStatus) kNodeProvider_ReadHealthLog(kNodeProvider provider, kHealthSummary* summary, kAlloc alloc); 
kFsFx(kStatus) kNodeProvider_ClearHealthLog(kNodeProvider provider);  
kFsFx(kStatus) kNodeProvider_GetNodeStats(kNodeProvider provider, kNodeStats* stats);  
kFsFx(kStatus) kNodeProvider_GetEventStats(kNodeProvider provider, k32u eventManagerId, kEventStats* stats);  
kFsFx(kStatus) kNodeProvider_GetCameraStats(kNodeProvider provider, kSize index, kCameraStats* stats);
kFsFx(kStatus) kNodeProvider_GetLightStats(kNodeProvider provider, kSize index, kLightStats* stats);
kFsFx(kStatus) kNodeProvider_GetProjectorStats(kNodeProvider provider, kSize index, kProjectorStats* stats);
kFsFx(kStatus) kNodeProvider_GetAnalogOutStats(kNodeProvider provider, kSize index, kAnalogOutStats* stats);
kFsFx(kStatus) kNodeProvider_GetDigitalOutStats(kNodeProvider provider, kSize index, kDigitalOutStats* stats);
kFsFx(kStatus) kNodeProvider_GetSerialOutStats(kNodeProvider provider, kSize index, kSerialOutStats* stats);

kFsFx(kStatus) kNodeProvider_ResetIoTest(kNodeProvider provider, kSize index);
kFsFx(kStatus) kNodeProvider_GetIoTestStats(kNodeProvider provider, kSize index, kIoTestStats* stats);
kFsFx(kStatus) kNodeProvider_ReadIoTestSerialData(kNodeProvider provider, kSize index, void* buffer, kSize capacity, kSize* bytesRead);

kFsFx(kStatus) kNodeProvider_TestJigCommand(kNodeProvider provider, kTestJigCommand command, k64u data);
kFsFx(kStatus) kNodeProvider_GetTestJigStats(kNodeProvider provider, kTestJigStats* stats);

kFsFx(kStatus) kNodeProvider_LockOutLight(kNodeProvider provider, kSize index, kBool shouldLock);
kFsFx(kStatus) kNodeProvider_SetLightDriverControl(kNodeProvider provider, kSize index, k64u key, kBool enabled);
kFsFx(kStatus) kNodeProvider_GetLightDriverControl(kNodeProvider provider, kSize index, k64u key, kBool* enabled);
kFsFx(kStatus) kNodeProvider_SetLightDriverPower(kNodeProvider provider, kSize index, k64u key, k32u power, kBool commit);
kFsFx(kStatus) kNodeProvider_GetLightDriverPower(kNodeProvider provider, kSize index, k64u key, k32u* power);
kFsFx(kStatus) kNodeProvider_SetLightDriverCurrentLimit(kNodeProvider provider, kSize index, k64u key, k32u currentLimit, kBool commit);
kFsFx(kStatus) kNodeProvider_GetLightDriverCurrentLimit(kNodeProvider provider, kSize index, k64u key, k32u* currentLimit);
kFsFx(kStatus) kNodeProvider_GetLightDriverRemainingSlotCount(kNodeProvider provider, kSize index, k64u key, kSize* remainingCount);
kFsFx(kStatus) kNodeProvider_SetLightDriverInfo(kNodeProvider provider, kSize index, k64u key, kLightModel model, kVersion revision, k32u deviceId);
kFsFx(kStatus) kNodeProvider_GetLightDriverInfo(kNodeProvider provider, kSize index, k64u key, kLightModel* model, kVersion* revision, k32u* deviceId);
kFsFx(kStatus) kNodeProvider_SetLightDriverCalibration(kNodeProvider provider, kSize index, k64u key, kDataTree ldCal, kBool commit);
kFsFx(kStatus) kNodeProvider_GetLightDriverCalibration(kNodeProvider provider, kSize index, k64u key, kDataTree* ldCal, kAlloc alloc);
kFsFx(kStatus) kNodeProvider_ReadLightDriverTemperature(kNodeProvider provider, kSize index, k64u key, k32s* temperature);

kFsFx(kStatus) kNodeProvider_StartOrientationCalibration(kNodeProvider provider);
kFsFx(kStatus) kNodeProvider_GetOrientationStats(kNodeProvider provider, kOrientationStats* stats);

#include <kFireSync/Client/Network/kNodeProvider.x.h>

#endif
