/** 
 * @file    kProjectorExt.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_EXT_X_H
#define K_FIRESYNC_PROJECTOR_EXT_X_H

#include <kApi/Data/kXml.h>

#define kPROJECTOR_EXT_DEFAULT_STATE_CAPACITY          (k8U_MAX)        

typedef struct kProjectorExtClass
{
    kObjectClass base; 
    kProjector projector;           //Optional reference to projector; used in client-side validation/verification. 
    kProjectorExtension typeId;     //Numeric type identifier. 
    kBool isSequence;               //Does this extension implement state sequencing logic?
    kBool requiresInterrupts;       //Does this extension require SoE/EoE interrupts to be enabled?
    kBool isEnabled;                //Is the extension currently enabled?
    kSize minStateCount;            //Can be set by child types to communicate minimum required projector states. 
    kSize maxStateCount;            //Can be set by child types to communicate maximum supported projector states. 
} kProjectorExtClass; 

typedef struct kProjectorExtVTable
{
    kObjectVTable base; 
    kStatus (kCall* VRead)(kProjectorExt extension, kXml xml, kXml item);    
    kStatus (kCall* VWrite)(kProjectorExt extension, kXml xml, kXml item);    
    kStatus (kCall* VVerify)(kProjectorExt extension); 
    kStatus (kCall* VClear)(kProjectorExt extension); 
    kStatus (kCall* VNextStates)(kProjectorExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
    k64u (kCall* VMinimumPeriod)(kProjectorExt extension); 
} kProjectorExtVTable; 

kDeclareVirtualClassEx(kFs, kProjectorExt, kObject)

kFsFx(kStatus) kProjectorExt_Construct(kProjectorExt* extension, kType type, kAlloc allocator); 

kFsFx(kStatus) kProjectorExt_Load(kProjectorExt* extension, kXml xml, kXmlItem item, kAlloc allocator); 
kFsFx(kStatus) kProjectorExt_Save(kProjectorExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjectorExt_Init(kProjectorExt extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kProjectorExt_VRelease(kProjectorExt extension); 

kFsFx(kProjectorExtension) kProjectorExt_TypeId(kProjectorExt extension); 

kFsFx(kStatus) kProjectorExt_Read(kProjectorExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjectorExt_VRead(kProjectorExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjectorExt_Write(kProjectorExt extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kProjectorExt_VWrite(kProjectorExt extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kProjectorExt_SetProjector(kProjectorExt extension, kProjector projector); 

kFsFx(kStatus) kProjectorExt_Clear(kProjectorExt extension); 
kFsFx(kStatus) kProjectorExt_VClear(kProjectorExt extension); 

kFsFx(kStatus) kProjectorExt_Verify(kProjectorExt extension); 
kFsFx(kStatus) kProjectorExt_VVerify(kProjectorExt extension); 

kFsFx(kBool) kProjectorExt_IsSequence(kProjectorExt extension); 
kFsFx(kBool) kProjectorExt_RequiresInterrupts(kProjectorExt extension); 

kFsFx(kStatus) kProjectorExt_NextStates(kProjectorExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 
kFsFx(kStatus) kProjectorExt_VNextStates(kProjectorExt extension, kSize stateIndex, kSize stateCount, kArrayList nextStates); 

kFsFx(k64u) kProjectorExt_MinimumPeriod(kProjectorExt extension); 
kFsFx(k64u) kProjectorExt_VMinimumPeriod(kProjectorExt extension); 

kFsFx(kSize) kProjectorExt_MinStateCount(kProjectorExt extension); 
kFsFx(kSize) kProjectorExt_MaxStateCount(kProjectorExt extension); 

#endif
