/** 
 * @file    kLp01Info.h
 * @brief   Declares the kLp01Info class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LP01_INFO_H
#define K_FIRESYNC_LP01_INFO_H

#include <kFireSync/Client/Projector/kProjectorInfo.h>

/**
 * @internal
 * @class   kLp01Info
 * @extends kProjectorInfo
 * @ingroup kFireSync-Client-Projector
 * @brief   Represents information about the LP01 projector model. 
 */
//typedef kProjectorInfo kLp01Info;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kLp01Info object.
 *
 * @public              @memberof kLp01Info
 * @param   info        Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kLp01Info_Construct(kLp01Info* info, k64f pixelClockFrequency, kAlloc allocator);

#include <kFireSync/Client/Projector/kLp01Info.x.h>

#endif
