/** 
 * @file    kStorageItem.x.h
 *
 * @internal
 * Copyright (C) 2020-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_STORAGE_ITEM_X_H
#define K_FIRESYNC_STORAGE_ITEM_X_H

#include <kApi/Io/kPath.h>

typedef struct kStorageItemClass
{
    kObjectClass base; 

    kString name;               // Item name.
    kStorageEntry entryType;    // Is this a regular file, directory, symbolic link, etc.?
    kSize fileSize;             // File size (0 for directory).
} kStorageItemClass; 

kDeclareClassEx(kFs, kStorageItem, kObject)
        
kFsFx(kStatus) kStorageItem_Construct(kStorageItem* storage, const kChar* name, kStorageEntry entryType, kSize fileSize, kAlloc allocator); 

kFsFx(kStatus) xkStorageItem_ConstructFramework(kStorageItem* storage, kAlloc allocator);
kFsFx(kStatus) xkStorageItem_InitFramework(kStorageItem storage, kType type, kAlloc alloc);

kFsFx(kStatus) xkStorageItem_Init(kStorageItem storage, kType type, const kChar* name, kStorageEntry entryType, kSize fileSize, kAlloc alloc); 
kFsFx(kStatus) xkStorageItem_VRelease(kStorageItem storage);

kFsFx(kStatus) xkStorageItem_WriteDat6V0(kStorageItem item, kSerializer serializer);
kFsFx(kStatus) xkStorageItem_ReadDat6V0(kStorageItem item, kSerializer serializer);

#endif
