/** 
 * @file    kCudaAlloc.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CUDA_ALLOC_X_H
#define K_FIRESYNC_CUDA_ALLOC_X_H

#include <kApi/kAlloc.h>

/*
 * kCudaDeviceAlloc class
 */

typedef struct kCudaDeviceAllocClass
{
    kAllocClass base;
} kCudaDeviceAllocClass;

kDeclareClassEx(kFs, kCudaDeviceAlloc, kAlloc)

kFsFx(kStatus) kCudaDeviceAlloc_Construct(kCudaDeviceAlloc* cudaAlloc, kObject allocator);

kFsFx(kStatus) xkCudaDeviceAlloc_Init(kCudaDeviceAlloc cudaAlloc, kType classType, kAlloc allocator);
kFsFx(kStatus) xkCudaDeviceAlloc_VRelease(kCudaDeviceAlloc cudaAlloc);

kFsFx(kStatus) xkCudaDeviceAlloc_VGet(kCudaDeviceAlloc cudaAlloc, kSize size, void* memory, kMemoryAlignment alignment);
kFsFx(kStatus) xkCudaDeviceAlloc_VFree(kCudaDeviceAlloc cudaAlloc, void* memory);

kFsFx(kStatus) xkCudaDeviceAlloc_VCopy(kCudaDeviceAlloc alloc, kAlloc destAlloc, void* dest, kAlloc srcAlloc, const void* src, kSize size, kObject context);

/*
 * kCudaManagedAlloc class
 */

typedef struct kCudaManagedAllocClass
{
    kAllocClass base;
} kCudaManagedAllocClass;

kDeclareClassEx(kFs, kCudaManagedAlloc, kAlloc)

kFsFx(kStatus) kCudaManagedAlloc_Construct(kCudaManagedAlloc* cudaAlloc, kObject allocator);

kFsFx(kStatus) xkCudaManagedAlloc_Init(kCudaManagedAlloc cudaAlloc, kType classType, kAlloc allocator);
kFsFx(kStatus) xkCudaManagedAlloc_VRelease(kCudaManagedAlloc cudaAlloc);

kFsFx(kStatus) xkCudaManagedAlloc_VGet(kCudaManagedAlloc cudaAlloc, kSize size, void* memory, kMemoryAlignment alignment);
kFsFx(kStatus) xkCudaManagedAlloc_VFree(kCudaManagedAlloc cudaAlloc, void* memory);

kFsFx(kStatus) xkCudaManagedAlloc_VCopy(kCudaManagedAlloc alloc, kAlloc destAlloc, void* dest, kAlloc srcAlloc, const void* src, kSize size, kObject context);

/*
 * kCudaPinnedAlloc class
 */

typedef struct kCudaPinnedAllocClass
{
    kAllocClass base;
} kCudaPinnedAllocClass;


kDeclareClassEx(kFs, kCudaPinnedAlloc, kAlloc)

kFsFx(kStatus) kCudaPinnedAlloc_Construct(kCudaPinnedAlloc* cudaAlloc, kObject allocator);

kFsFx(kStatus) xkCudaPinnedAlloc_Init(kCudaPinnedAlloc cudaAlloc, kType classType, kAlloc allocator);
kFsFx(kStatus) xkCudaPinnedAlloc_VRelease(kCudaPinnedAlloc cudaAlloc);

kFsFx(kStatus) xkCudaPinnedAlloc_VGet(kCudaPinnedAlloc cudaAlloc, kSize size, void* memory, kMemoryAlignment alignment);
kFsFx(kStatus) xkCudaPinnedAlloc_VFree(kCudaPinnedAlloc cudaAlloc, void* memory);

kFsFx(kStatus) xkCudaPinnedAlloc_VCopy(kCudaPinnedAlloc alloc, kAlloc destAlloc, void* dest, kAlloc srcAlloc, const void* src, kSize size, kObject context);

/*
 * kCudaAlloc static class
 */

typedef struct kCudaAllocStatic
{
    kCudaDeviceAlloc deviceAlloc;             //Cuda device memory allocator -- created for use by application code.
    kCudaManagedAlloc managedAlloc;           //Cuda managed memory allocator -- created for use by application code.
    kCudaPinnedAlloc pinnedAlloc;             //Cuda pinned memory allocator -- created for use by application code.
} kCudaAllocStatic;

kDeclareStaticClassEx(kFs, kCudaAlloc)

kFsFx(kStatus) xkCudaAlloc_InitStatic();
kFsFx(kStatus) xkCudaAlloc_ReleaseStatic();

kFsFx(kStatus) xkCudaAlloc_Copy(kCudaStream stream, kAlloc destAlloc, void* dest, kAlloc sourceAlloc, const void* src, kSize size, kCudaSync sync = kCUDA_SYNC_DEFAULT);


//deprecated
#define kCudaAlloc_Device kCudaDeviceAlloc_Instance
#define kCudaAlloc_Managed kCudaManagedAlloc_Instance
#define kCudaAlloc_Pinned kCudaPinnedAlloc_Instance 

//deprecated
#define kCUDA_MEMORY_MANAGED    (0)
#define kCUDA_MEMORY_HOST       (1)
#define kCUDA_MEMORY_DEVICE     (2)

//deprecated
kFsFx(kStatus) kCudaAlloc_Construct(kCudaAlloc* cudaAlloc, k32s memoryType, kObject allocator);

#endif
