/** 
 * @file    kArchive.h
 * @brief   Declares the kArchive class. 
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ARCHIVE_H
#define K_FIRESYNC_ARCHIVE_H

#include <kFireSync/kFsDef.h>

//typedef kObject kArchive;         --forward-declared in kFsDef.x.h

typedef struct kArchiveFileInfo
{
    k64u attributes;
    k64u time;
} kArchiveFileInfo;

// TODO:
// - Add a flag to allow choosing between "fast load" and "full load"
//  currently only fast load is supported which does not parse the file
//  into an editable structure. This is useful on devices with limited
//  resources such as the DSP. However on the host where package generation
//  and possibly modification takes place, it is more desirable to be
//  able to load an archive and then work on that.

kFsFx(kStatus) kArchive_Construct(kArchive *archive, kAlloc alloc);

kFsFx(kStatus) kArchive_Load(kArchive archive, const kChar *fileName);
kFsFx(kStatus) kArchive_Save(kArchive archive, const kChar *fileName);

kFsFx(kStatus) kArchive_Read(kArchive archive, kStream stream);
kFsFx(kStatus) kArchive_Write(kArchive archive, kStream stream);

kFsFx(kStatus) kArchive_ReadSerializer(kArchive archive, kSerializer serializer);

kFsFx(k64u) kArchive_Size(kArchive archive);
kFsFx(k32u) kArchive_Crc(kArchive archive);

kFsFx(kStatus) kArchive_Attach(kArchive archive, const void *data, k64u length);
kFsFx(kStatus) kArchive_Detach(kArchive archive);

kFsFx(kStatus) kArchive_AddData(kArchive archive, const void *data, k64u size, const kChar *fileName, const kArchiveFileInfo *info);
kFsFx(kStatus) kArchive_AddFile(kArchive archive, const kChar *sourceFile, const kChar *destFile);
kFsFx(kStatus) kArchive_DeleteFile(kArchive archive, const kChar* fileName);

kFsFx(kStatus) kArchive_AddDirectory(kArchive archive, const kChar* sourceDir, const kChar *destBaseDir);

kFsFx(kStatus) kArchive_Extract(kArchive archive, const kChar *destDir);

kFsFx(kSize) kArchive_Count(kArchive archive);
kFsFx(kStatus) kArchive_Find(kArchive archive, const kChar *fileName, kSize *index);

kFsFx(k64u) kArchive_FileSize(kArchive archive, kSize fileIndex);
kFsFx(const void*) kArchive_FileData(kArchive archive, kSize fileIndex);
kFsFx(const kChar*) kArchive_FileName(kArchive archive, kSize fileIndex);
kFsFx(kStatus) kArchive_FileInfo(kArchive archive, kSize fileIndex, kArchiveFileInfo *fileInfo);

#include <kFireSync/Data/kArchive.x.h>

#endif
