/** 
 * @file    kBinCSumMsg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BINCSUM_MSG_X_H
#define K_FIRESYNC_BINCSUM_MSG_X_H

#define kBIN_CSUM_MSG_STAMP_PART            (0)     //Index of stamp part in kAlgMsg. 
#define kBIN_CSUM_MSG_BIN_PART              (1)     //Index of bin part in kAlgMsg.
#define kBIN_CSUM_MSG_CSUM_PART             (2)     //Index of csum part in kAlgMsg.

/* 
 * NOTE: kBinCSumMsg does not currently add any data members beyond its base class. 
 * IF members are added in future, it will require overriding serveral virtual methods
 * inherited from kAlgMsg to provide correct functionality.
*/  
typedef struct kBinCSumMsgClass
{
    kAlgMsgClass base; 
} kBinCSumMsgClass; 

kDeclareClassEx(kFs, kBinCSumMsg, kAlgMsg)

/*
* Forward declarations
*/

kFsFx(kStatus) kBinCSumMsg_Attach(kBinCSumMsg msg, kSize frameIndex, kStamp* stamp, void* bin, void* csum);
kFsFx(kType) kBinCSumMsg_BinType(kBinCSumMsg msg);
kFsFx(void*) kBinCSumMsg_BinAt(kBinCSumMsg msg, kSize frameIndex, kSize rowIndex);
kFsFx(kType) kBinCSumMsg_CSumType(kBinCSumMsg msg);
kFsFx(void*) kBinCSumMsg_CSumAt(kBinCSumMsg msg, kSize frameIndex);

/*
* Private methods
*/
        
kFsFx(kStatus) kBinCSumMsg_Init(kBinCSumMsg msg, kType type, kSize binWidth, kSize binHeight, kType csumType, kSize csumLength, kSize frameCount, kBool allocate, kAlloc alloc);

kFsFx(kStatus) xkBinCSumMsg_ConstructFramework(kBinCSumMsg* msg, kAlloc allocator); 
kFsFx(kStatus) xkBinCSumMsg_InitFramework(kBinCSumMsg msg, kType type, kAlloc alloc);

kFsFx(kStatus) xkBinCSumMsg_WriteDat6V0(kBinCSumMsg msg, kSerializer serializer);
kFsFx(kStatus) xkBinCSumMsg_ReadDat6V0(kBinCSumMsg msg, kSerializer serializer);

kFsFx(kStatus) kBinCSumMsg_VDataAt(kBinCSumMsg msg, kSize index, kArrayList* list);
kFsFx(kStatus) kBinCSumMsg_GeneratePlot(kBinCSumMsg msg, kImage bin, kArray1 csum, kPlot* plot, kAlloc allocator); 

kInlineFx(kStatus) xkBinCSumMsg_AttachT(kBinCSumMsg msg, kSize frameIndex, kStamp* stamp, void* bin, void* csum, kSize binSize, kSize csumSize)
{
    kAssert(xkType_IsPointerCompatible(kBinCSumMsg_BinType(msg), binSize)); 
    kAssert(xkType_IsPointerCompatible(kBinCSumMsg_CSumType(msg), csumSize)); 

    return kBinCSumMsg_Attach(msg, frameIndex, stamp, bin, csum);
} 

kInlineFx(void*) xkBinCSumMsg_BinAtT(kBinCSumMsg msg, kSize frameIndex, kSize rowIndex, kSize binSize)
{
    kAssert(xkType_IsPointerCompatible(kBinCSumMsg_BinType(msg), binSize)); 

    return kBinCSumMsg_BinAt(msg, frameIndex, rowIndex);
} 

kInlineFx(void*) xkBinCSumMsg_CSumAtT(kBinCSumMsg msg, kSize frameIndex, kSize csumSize)
{
    kAssert(xkType_IsPointerCompatible(kBinCSumMsg_CSumType(msg), csumSize)); 

    return kBinCSumMsg_CSumAt(msg, frameIndex);
} 

#endif
