/** 
 * @file    kDataTree.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DATA_TREE_X_H
#define K_FIRESYNC_DATA_TREE_X_H

#include <kApi/Io/kSerializer.h>
#include <kFireSync/Data/kDataTreeItem.x.h>

typedef struct kDataTreeClass 
{
    kObjectClass base; 
    kDataTreeItem root; 
} kDataTreeClass;

kDeclareClassEx(kFs, kDataTree, kObject)

kFsFx(kStatus) kDataTree_Init(kDataTree tree, kType classType, kAlloc allocator);
kFsFx(kStatus) kDataTree_VRelease(kDataTree tree);
kFsFx(kStatus) kDataTree_VClone(kDataTree tree, kDataTree source, kAlloc valueAlloc, kObject context);

kFsFx(kBool) kDataTree_VHasShared(kDataTree tree); 
kFsFx(kSize) kDataTree_VSize(kDataTree tree);
kFsFx(kAllocTrait) kDataTree_VAllocTraits(kDataTree tree);

kFsFx(kStatus) xkDataTree_WriteDat5V0(kDataTree tree, kSerializer serializer);
kFsFx(kStatus) xkDataTree_ReadDat5V0(kDataTree tree, kSerializer serializer);
kFsFx(kStatus) xkDataTree_WriteDat6V0(kDataTree tree, kSerializer serializer);
kFsFx(kStatus) xkDataTree_ReadDat6V0(kDataTree tree, kSerializer serializer);
kFsFx(kStatus) kDataTree_SetChildValue(kDataTree tree, kDataTreeItem parent, const kChar* path, kType type, const void* value); 
kFsFx(kStatus) kDataTree_EnsureExists(kDataTree tree, kDataTreeItem parent, const kChar* path, kDataTreeItem* item); 
kFsFx(kStatus) kDataTree_ChildValue(kDataTree tree, kDataTreeItem parent, const kChar* path, kType type, void* value); 

/* legacy */
kFsFx(kStatus) kDataTree_SetItemString(kDataTree tree, kDataTreeItem item, const kChar* value); 
kFsFx(kStatus) kDataTree_ItemString(kDataTree tree, kDataTreeItem item, kChar* value, k32u capacity); 
kFsFx(kStatus) kDataTree_SetChildString(kDataTree tree, kDataTreeItem parent, const kChar* path, const kChar* value); 
kFsFx(kStatus) kDataTree_ChildString(kDataTree tree, kDataTreeItem parent, const kChar* path, kChar* value, k32u capacity); 
kFsFx(kObject) kDataTree_GetItemData(kDataTree tree, kDataTreeItem item);
kFsFx(kStatus) kDataTree_SetItemData(kDataTree tree, kDataTreeItem item, kObject value);
kFsFx(kStatus) kDataTree_ItemData(kDataTree tree, kDataTreeItem item, kObject* value, kAlloc allocator);
kFsFx(kStatus) kDataTree_SetChildData(kDataTree tree, kDataTreeItem parent, const kChar* path, kObject value);
kFsFx(kStatus) kDataTree_ChildData(kDataTree tree, kDataTreeItem parent, const kChar* path, kObject* value, kAlloc allocator);

#endif
