/** 
 * @file    kMovingAvg.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MOVING_AVG_X_H
#define K_FIRESYNC_MOVING_AVG_X_H

#include <kApi/Data/kArray1.h>

typedef struct kMovingAvgClass
{
    kObjectClass base; 
    kArray1 samples;           ///Data -- kArray1<k64s>
    kSize writeIndex;          ///Write location for next sample.
    kSize count;               ///Count of items contributing to sum. 
    k64s sum;                  ///Sum of currently buffered samples. 
} kMovingAvgClass; 

kDeclareClassEx(kFs, kMovingAvg, kObject)
        
kFsFx(kStatus) kMovingAvg_Init(kMovingAvg stat, kType type, kSize window, kAlloc alloc); 
kFsFx(kStatus) kMovingAvg_VRelease(kMovingAvg stat); 

#endif
