/** 
 * @file    kTerrainModel.h
 * @brief   Declares the kTerrainModel class.
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TERRAIN_MODEL_H
#define K_FIRESYNC_TERRAIN_MODEL_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Data/kTerrainModel.x.h>

//typedef kObject kTerrainModel;            --forward-declared in kFsDef.x.h

kFsFx(kStatus) kTerrainModel_Construct(kTerrainModel* model, k32u minimumRegions, kAlloc allocator); 

kFsFx(kStatus) kTerrainModel_Add(kTerrainModel model, const kTerrain* item);
kFsFx(kStatus) kTerrainModel_Clear(kTerrainModel model);

kFsFx(kTerrain*) kTerrainModel_At(kTerrainModel model, k32u index); 
kFsFx(kSize) kTerrainModel_RegionCount(kTerrainModel model); 

kFsFx(k32s) kTerrainModel_GetSuppressedValue(kTerrainModel model);
kFsFx(kStatus) kTerrainModel_SetSuppressedValue(kTerrainModel model,k32s value);

kFsFx(kBool) kTerrainModel_IsSuppressionEnabled(kTerrainModel model);
kFsFx(kStatus) kTerrainModel_EnableSuppression(kTerrainModel model,kBool enable);

#endif
