/** 
 * @file    kUnpackedCompressedPhase.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_UNPACKED_COMPRESSED_PHASE_X_H
#define K_FIRESYNC_UNPACKED_COMPRESSED_PHASE_X_H

typedef struct kUnpackedCompressedPhaseClass
{
    kObjectClass base; 

    kBool isIntensity;          //represents intensity data (vs phase)?

    k32s prediction;            //phase prediction value

    kSize subframeLength;       //number of uncompressed items represented by this data
    kSize length[2];            //original dimension lengths of uncompressed 2D array

    k32u deltaBitDepth;         //bit depth of delta list items
    k32u fail1BitDepth;         //bit depth of fail1 list items
    k32u fail2BitDepth;         //bit depth of fail2 list items
    k32u nullBitDepth;          //bit depth of null list items
    
    kArrayList deltaList;       //delta list -- kArrayList<k32s>
    kArrayList fail1List;       //fail1 list -- kArrayList<kPair32s>
    kArrayList fail2List;       //fail2 list -- kArrayList<kPair32s>
    kArrayList nullList;        //null list -- kArrayList<kPair32s>
} kUnpackedCompressedPhaseClass; 

kDeclareClassEx(kFs, kUnpackedCompressedPhase, kObject)
        
kFsFx(kStatus) xkUnpackedCompressedPhase_Init(kUnpackedCompressedPhase data, kType type, kAlloc alloc); 
kFsFx(kStatus) xkUnpackedCompressedPhase_VRelease(kUnpackedCompressedPhase data); 

#endif
