/** 
 * @file    kHxCameraExt.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_CAMERA_EXT_X_H
#define K_FIRESYNC_HX_CAMERA_EXT_X_H

typedef struct kHxCameraExtVTable
{
    kObjectVTable base;  

    kStatus (kCall* VOverride)(kHxCameraExt extension, const kCameraOverrideItem* overrides, kSize count);
 
} kHxCameraExtVTable;

typedef struct kHxCameraExtClass
{
    kObjectClass base;     

    /* 
     * Read-only attributes established during init.
     */

    kHxCamera camera;               //Parent.
    kCameraExt config;              //Configuration object.

} kHxCameraExtClass;

kDeclareVirtualClassEx(kFs, kHxCameraExt, kObject)

//instances of this class can be constructed by hardware implementations that do not subclass extensions (i.e., kHwVirtual). 
kFsFx(kStatus) xkHxCameraExt_Construct(kHxCameraExt* extension, kHxCamera camera, kCameraExt config, kAlloc allocator);

kFsFx(kStatus) xkHxCameraExt_Init(kHxCameraExt ext, kType type, kHxCamera camera, kCameraExt config, kAlloc alloc);

kFsFx(kStatus) xkHxCameraExt_VRelease(kHxCameraExt ext); 

kInlineFx(kStatus) xkHxCameraExt_VOverride(kHxCameraExt ext, const kCameraOverrideItem* overrides, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}


#endif
