/** 
 * @file    kHxCameraState.h
 * @brief   Declares the kHxCameraState class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_CAMERA_STATE_H
#define K_FIRESYNC_HX_CAMERA_STATE_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxCameraState.x.h>

/**
 * @class       kHxCameraState
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware camera-state classes.
 */
//typedef kObject kHxCamera;      --forward-declared in kFsDef.x.h

kInlineFx(kStatus) kHxCameraState_SetExposureMode(kHxCameraState state, kCameraExposure mode)
{
    kObj(kHxCameraState, state);

    obj->exposureMode = mode; 

    return kOK; 
}

kInlineFx(kCameraExposure) kHxCameraState_ExposureMode(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->exposureMode;
}

kInlineFx(kStatus) kHxCameraState_SetMaxBatchSize(kHxCameraState state, kSize maxBatchSize)
{
    kObj(kHxCameraState, state);

    obj->maxBatchSize = maxBatchSize; 

    return kOK; 
}

kInlineFx(kSize) kHxCameraState_MaxBatchSize(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->maxBatchSize; 
}

kInlineFx(kStatus) kHxCameraState_SetDelay(kHxCameraState state, k64u delay)
{
    kObj(kHxCameraState, state);

    obj->delay = delay; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_Delay(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->delay;
}

kInlineFx(kStatus) kHxCameraState_SetExposure(kHxCameraState state, k64u exposure)
{
    kObj(kHxCameraState, state);

    obj->exposure = exposure; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_Exposure(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->exposure; 
}

kInlineFx(kStatus) kHxCameraState_SetGap(kHxCameraState state, k64u gap)
{
    kObj(kHxCameraState, state);

    obj->gap = gap; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_Gap(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->gap;
}

kInlineFx(kStatus) kHxCameraState_SetReadoutTime(kHxCameraState state, k64u readoutTime)
{
    kObj(kHxCameraState, state);

    obj->readoutTime = readoutTime; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_ReadoutTime(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->readoutTime;
}

kInlineFx(kStatus) kHxCameraState_SetInterExposureGap(kHxCameraState state, k64u interExposureGap)
{
    kObj(kHxCameraState, state);

    obj->interExposureGap = interExposureGap; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_InterExposureGap(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->interExposureGap;
}

kInlineFx(kStatus) kHxCameraState_SetLeadIn(kHxCameraState state, k64u leadIn)
{
    kObj(kHxCameraState, state);

    obj->leadIn = leadIn; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_LeadIn(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->leadIn;
}

kInlineFx(kStatus) kHxCameraState_SetTotalLeadIn(kHxCameraState state, k64u totalLeadIn)
{
    kObj(kHxCameraState, state);

    obj->totalLeadIn = totalLeadIn; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_TotalLeadIn(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->totalLeadIn;
}

kInlineFx(kStatus) kHxCameraState_SetLeadOut(kHxCameraState state, k64u leadOut)
{
    kObj(kHxCameraState, state);

    obj->leadOut = leadOut; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_LeadOut(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->leadOut;
}

kInlineFx(kStatus) kHxCameraState_SetTotalLeadOut(kHxCameraState state, k64u totalLeadOut)
{
    kObj(kHxCameraState, state);

    obj->totalLeadOut = totalLeadOut; 

    return kOK; 
}

kInlineFx(k64u) kHxCameraState_TotalLeadOut(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->totalLeadOut;
}

kInlineFx(kStatus) kHxCameraState_SetGain(kHxCameraState state, kCameraGain channel, k32u gain)
{
    kObj(kHxCameraState, state);

    kAssert(channel < kCAMERA_GAIN_CAPACITY); 

    obj->gain[channel] = gain; 

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_Gain(kHxCameraState state, kCameraGain channel)
{
    kObj(kHxCameraState, state);

    kAssert(channel < kCAMERA_GAIN_CAPACITY); 

    return obj->gain[channel];
}

kInlineFx(kStatus) kHxCameraState_SetKneeCount(kHxCameraState state, kSize count)
{
    kObj(kHxCameraState, state);

    return kArrayList_Resize(obj->kneePoints, count); 
}

kInlineFx(kSize) kHxCameraState_KneeCount(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return kArrayList_Count(obj->kneePoints);
}

kInlineFx(kStatus) kHxCameraState_SetKneeExposureTime(kHxCameraState state, kSize index, k64f exposureTime)
{
    kObj(kHxCameraState, state);
    kPoint64f* kneePoint = kArrayList_AtT(obj->kneePoints, index, kPoint64f);

    kneePoint->x = exposureTime;

    return kOK;
}

kInlineFx(k64f) kHxCameraState_KneeExposureTime(kHxCameraState state, kSize index)
{
    kObj(kHxCameraState, state);
    kPoint64f* kneePoint = kArrayList_AtT(obj->kneePoints, index, kPoint64f);

    return kneePoint->x;
}

kInlineFx(kStatus) kHxCameraState_SetKneeOutputCap(kHxCameraState state, kSize index, k64f outputCap)
{
    kObj(kHxCameraState, state);
    kPoint64f* kneePoint = kArrayList_AtT(obj->kneePoints, index, kPoint64f);

    kneePoint->y = outputCap;

    return kOK;
}

kInlineFx(k64f) kHxCameraState_KneeOutputCap(kHxCameraState state, kSize index)
{
    kObj(kHxCameraState, state);
    kPoint64f* kneePoint = kArrayList_AtT(obj->kneePoints, index, kPoint64f);

    return kneePoint->y;
}

kInlineFx(kStatus) kHxCameraState_EnableAutoBlack(kHxCameraState state, kBool enabled)
{
    kObj(kHxCameraState, state);

    obj->autoBlack = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxCameraState_AutoBlackEnabled(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->autoBlack;
}

kInlineFx(kStatus) kHxCameraState_SetBlack(kHxCameraState state, k32s level)
{
    kObj(kHxCameraState, state);

    obj->blackLevel = level; 

    return kOK; 
}

kInlineFx(k32s) kHxCameraState_Black(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->blackLevel; 
}

kInlineFx(kStatus) kHxCameraState_SetTop(kHxCameraState state, k32u top)
{
    kObj(kHxCameraState, state);

    obj->top = top; 

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_Top(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->top;
}

kInlineFx(kStatus) kHxCameraState_SetLeft(kHxCameraState state, k32u left)
{
    kObj(kHxCameraState, state);

    obj->left = left;

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_Left(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->left;
}

kInlineFx(kStatus) kHxCameraState_SetWidth(kHxCameraState state, k32u width)
{
    kObj(kHxCameraState, state);

    obj->width = width;

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_Width(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->width;
}

kInlineFx(kStatus) kHxCameraState_SetHeight(kHxCameraState state, k32u height)
{
    kObj(kHxCameraState, state);

    obj->height = height;

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_Height(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->height; 
}

kInlineFx(kStatus) kHxCameraState_SetXSubsampling(kHxCameraState state, k32u sub)
{
    kObj(kHxCameraState, state);

    obj->xSub = sub;

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_XSubsampling(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->xSub; 
}

kInlineFx(kStatus) kHxCameraState_SetXSubsamplingMode(kHxCameraState state, kCameraSubsampling mode)
{
    kObj(kHxCameraState, state);

    obj->xSubMode = mode; 

    return kOK; 
}

kInlineFx(kCameraSubsampling) kHxCameraState_XSubsamplingMode(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->xSubMode;
}

kInlineFx(kStatus) kHxCameraState_SetYSubsampling(kHxCameraState state, k32u sub)
{
    kObj(kHxCameraState, state);

    obj->ySub = sub; 

    return kOK; 
}

kInlineFx(k32u) kHxCameraState_YSubsampling(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->ySub;
}

kInlineFx(kStatus) kHxCameraState_SetYSubsamplingMode(kHxCameraState state, kCameraSubsampling mode)
{
    kObj(kHxCameraState, state);

    obj->ySubMode = mode; 

    return kOK; 
}

kInlineFx(kCameraSubsampling) kHxCameraState_YSubsamplingMode(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->ySubMode;
}

kInlineFx(kStatus) kHxCameraState_EnableXInversion(kHxCameraState state, kBool enabled)
{
    kObj(kHxCameraState, state);

    obj->invertX = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxCameraState_XInversionEnabled(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->invertX;
}

kInlineFx(kStatus) kHxCameraState_EnableYInversion(kHxCameraState state, kBool enabled)
{
    kObj(kHxCameraState, state);

    obj->invertY = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxCameraState_YInversionEnabled(kHxCameraState state)
{
    kObj(kHxCameraState, state);

    return obj->invertY;
}

//ownership of 'info' not transferred
kFsFx(kStatus) kHxCameraState_SetAlgorithmConfig(kHxCameraState state, kAlgInfo info);

//emits 'info' object that must be destroyed by caller
kFsFx(kStatus) kHxCameraState_AlgorithmConfig(kHxCameraState state, kAlgInfo* info, kAlloc allocator);

kInlineFx(kStatus) kHxCameraState_SetRamImageCount(kHxCameraState state, kSize count)
{
    return xkHxCameraState_VTable(state)->VSetRamImageCount(state, count);
}

kInlineFx(kSize) kHxCameraState_RamImageCount(kHxCameraState state)
{
    return xkHxCameraState_VTable(state)->VRamImageCount(state);
}

kInlineFx(kStatus) kHxCameraState_WriteRamImage(kHxCameraState state, kSize imageIndex, kImage image)
{
    return xkHxCameraState_VTable(state)->VWriteRamImage(state, imageIndex, image);
}


#endif
