/** 
 * @file    kHxEncoder.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_ENCODER_X_H
#define K_FIRESYNC_HX_ENCODER_X_H

#define kHX_ENCODER_DEFAULT_SIMULATION_PERIOD              (1000000)             //Default period (fs ns). 


typedef struct kHxEncoderVTable
{
    kObjectVTable base; 

    kStatus (kCall* VApply)(kHxEncoder encoder);
    kStatus (kCall* VReset)(kHxEncoder encoder);
    kStatus (kCall* VClear)(kHxEncoder encoder);
    kStatus (kCall* VClearDevice)(kHxEncoder encoder);

} kHxEncoderVTable;

typedef struct kHxEncoderClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                           //Parent.
    kBool enabled;                          //Is this module enabled?

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kEncoderDirection direction;            //Encoder polarity
    kBool indexReset;                       //Reset counter at index pulse?

    kBool simulatorEnabled;                 //Enable encoder simulator?
    kBool simulatorDirection;               //Encoder simulator direction. 
    k64u simulatorPeriod;                   //Encoder simulator period
    k32u simulatorResolution;               //Encoder simulator resolution

    kEncoderSnapshotSource snapshotSource;  //Encoder snapshot source
    k32u snapshotSourceId;                  //Encoder snapshot source id

} kHxEncoderClass;

kDeclareVirtualClassEx(kFs, kHxEncoder, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxEncoder_Init(kHxEncoder encoder, kType type, kHxNode node, kAlloc alloc); 

kFsFx(kStatus) xkHxEncoder_VRelease(kHxEncoder encoder); 

kInlineFx(kStatus) xkHxEncoder_VApply(kHxEncoder encoder)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxEncoder_VReset(kHxEncoder encoder)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxEncoder_VClear(kHxEncoder encoder);

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxEncoder_VClearDevice(kHxEncoder encoder);


#endif
