/** 
 * @file    kHxProjector.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_PROJECTOR_X_H
#define K_FIRESYNC_HX_PROJECTOR_X_H

typedef struct kHxProjectorVTable
{
    kObjectVTable base; 

    kBool (kCall* VIsConnected)(kHxProjector projector); 
    k32u (kCall* VMinIntensity)(kHxProjector projector);   
    k32u (kCall* VMaxIntensity)(kHxProjector projector);   
    kStatus (kCall* VLoadPatterns)(kHxProjector projector, kArray2 patterns);   
    kStatus (kCall* VLoadRowGains)(kHxProjector projector, kArray1 gains);   
    kStatus (kCall* VLoadColGains)(kHxProjector projector, kArray1 gains);   
    kStatus (kCall* VSetStateCount)(kHxProjector projector, kSize count);
    kStatus (kCall* VAddExtension)(kHxProjector projector, kProjectorExt extension);
    kStatus (kCall* VStats)(kHxProjector projector, kProjectorStats* stats);
    kStatus (kCall* VClear)(kHxProjector projector);

} kHxProjectorVTable;

typedef struct kHxProjectorClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                               //Parent.
    kSize index;                                //Index of this object in parent context.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kProjectorInfo info;                        //Projector model information.
    k64f pixelClockFrequency;                   //Pixel clock frequency (Hz). 

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                              //Projector enabled setting.
    kProjectorControl controlType;              //Control mode setting.
    kSize controlId;                            //Control id setting.

    kBool dynamicFrameRate;                     //Is dynamic frame rate enabled?
    kBool lightOutput;                          //Is light output enabled?
    kBool autoShutdown;                         //Is auto-shutdown enabled?
    kSize patternCount;                         //Number of patterns in a sequence.
    kSize bitDepth;                             //Projected pattern bit depth.
    kProjectorPatternMode patternMode;          //Pattern mode.
    k32u palette[kPROJECTOR_PALETTE_CAPACITY];  //Pixel palette when in 2D_1BPP pattern mode.

    kArrayList states;                          //Projector states -- kArrayList<kHxProjectorState>.
    kArrayList extensions;                      //Projector control extensions -- kArrayList<kHxProjectorExt>.

} kHxProjectorClass;

kDeclareVirtualClassEx(kFs, kHxProjector, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxProjector_Init(kHxProjector projector, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxProjector_VRelease(kHxProjector projector); 

kInlineFx(kBool) xkHxProjector_VIsConnected(kHxProjector projector)
{
    return kFALSE;
}

kInlineFx(k32u) xkHxProjector_VMinIntensity(kHxProjector projector)
{
    kObj(kHxProjector, projector); 

    return kProjectorInfo_MinIntensity(obj->info);
}

kInlineFx(k32u) xkHxProjector_VMaxIntensity(kHxProjector projector)
{
    kObj(kHxProjector, projector); 

    return kProjectorInfo_MaxIntensity(obj->info);
}

kInlineFx(kStatus) xkHxProjector_VLoadPatterns(kHxProjector projector, kArray2 patterns)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxProjector_VLoadRowGains(kHxProjector projector, kArray1 gains)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxProjector_VLoadColGains(kHxProjector projector, kArray1 gains)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxProjector_VSetStateCount(kHxProjector projector, kSize count)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxProjector_VAddExtension(kHxProjector projector, kProjectorExt extension)
{
    return kERROR_UNIMPLEMENTED;
}


kInlineFx(kStatus) xkHxProjector_VStats(kHxProjector projector, kProjectorStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}


//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxProjector_VClear(kHxProjector projector);

#endif
