/** 
 * @file    kHxSerialOut.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_SERIAL_OUT_X_H
#define K_FIRESYNC_HX_SERIAL_OUT_X_H

#define kHX_SERIAL_DEFAULT_BIT_RATE             (115200)

typedef struct kHxSerialOutVTable
{
    kObjectVTable base; 

    kStatus (kCall* VWrite)(kHxSerialOut serial, const void* buffer, kSize size);
    kStatus (kCall* VStats)(kHxSerialOut serial, kSerialOutStats* stats);
    kStatus (kCall* VClear)(kHxSerialOut serial);

} kHxSerialOutVTable;

typedef struct kHxSerialOutClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                       //Parent.
    kSize index;                        //Index of this object in parent context.

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                      //SerialOut enabled setting.
    kSerialOutMode mode;                //Serial transmission mode.
    kSerialOutControl controlType;      //Control mode setting.
    kSize controlId;                    //Control id setting.
    k32s bitRate;                       //Serial bit rate. 

} kHxSerialOutClass;

kDeclareVirtualClassEx(kFs, kHxSerialOut, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxSerialOut_Init(kHxSerialOut serial, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxSerialOut_VRelease(kHxSerialOut serial); 

kInlineFx(kStatus) xkHxSerialOut_VWrite(kHxSerialOut serial, const void* buffer, kSize size)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxSerialOut_VStats(kHxSerialOut serial, kSerialOutStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxSerialOut_VClear(kHxSerialOut serial);

#endif
