/** 
 * @file    kPacketUtils.x.h
 *
 * @internal
 * Copyright (C) 2019-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_PACKET_UTILS_X_H
#define K_PACKET_UTILS_X_H

 /* Hardware address type */
#define xkPACKET_UTILS_HARDWARE_TYPE_10_ETHERNET                (1)             // ARP/DHCP hardware type for ethernet (https://tools.ietf.org/html/rfc1060)
#define xkPACKET_UTILS_HARDWARE_MAX_FRAME_LENGTH                (1522)          // Maximal time for processing DHCP messages, = maximum ethernet frame size.

#define xkPACKET_UTILS_IP_TOS_IMMEDIATE                         (0x10)          // Immediate TOS flag.
#define xkPACKET_UTILS_IP_ID                                    (0xffff)        // ID, no fragmentation so no need to be unique (https://tools.ietf.org/html/rfc6864#page-4).
#define xkPACKET_UTILS_IP_TTL                                   (64)            // TTL, recommended default is 64 (https://www.iana.org/assignments/ip-parameters/ip-parameters.xml)

/* DHCP option codes */
#define xkPACKET_UTILS_DHCP_OPT_SUBNET_MASK                     (1)     // DHCP subnet option.
#define xkPACKET_UTILS_DHCP_OPT_ROUTER                          (3)     // DHCP router option.
#define xkPACKET_UTILS_DHCP_OPT_REQ_IP                          (50)    // DHCP client IP address option.
#define xkPACKET_UTILS_DHCP_OPT_LEASE_TIME                      (51)    // DHCP lease time option.
#define xkPACKET_UTILS_DHCP_OPT_MESSAGE_TYPE                    (53)    // DHCP message type.
#define xkPACKET_UTILS_DHCP_OPT_SERVER_IDENTIFIER               (54)    // DHCP server identifier.
#define xkPACKET_UTILS_DHCP_OPT_PARAMETER_REQ_LIST              (55)    // DHCP requested parameter list.
#define xkPACKET_UTILS_DHCP_OPT_RENEWAL_TIME                    (58)    // DHCP renewal time.
#define xkPACKET_UTILS_DHCP_OPT_REBINDING_TIME                  (59)    // DHCP rebinding time.
#define xkPACKET_UTILS_DHCP_OPT_CLIENT_IDENTIFIER               (61)    // DHCP client identifier.
#define xkPACKET_UTILS_DHCP_OPT_END                             (255)   // DHCP option end marker.

/* DHCP messages */
#define xkPACKET_UTILS_DHCP_MESSAGE_DISCOVER                    (1)     // DHCP discover message (client -> server).
#define xkPACKET_UTILS_DHCP_MESSAGE_OFFER                       (2)     // DHCP offer message (server -> client).
#define xkPACKET_UTILS_DHCP_MESSAGE_REQUEST                     (3)     // DHCP request message (client -> server).
#define xkPACKET_UTILS_DHCP_MESSAGE_DECLINE                     (4)     // DHCP decline message (client -> server).
#define xkPACKET_UTILS_DHCP_MESSAGE_ACK                         (5)     // DHCP acknowledge message (server -> client).
#define xkPACKET_UTILS_DHCP_MESSAGE_NAK                         (6)     // DHCP denied message (server -> client).
#define xkPACKET_UTILS_DHCP_MESSAGE_RELEASE                     (7)     // DHCP release message (client -> server).

/* DHCP message operation codes */
#define xkPACKET_UTILS_DHCP_BOOTREQUEST                         (1)     // DHCP request operation.
#define xkPACKET_UTILS_DHCP_BOOTREPLY                           (2)     // DHCP reply operation.

/* DHCP magic cookie, first value in option field */
#define xkPACKET_UTILS_DHCP_MAGIC_COOKIE                        (0x63825363)   // DHCP magic cookie

#define xkPACKET_UTILS_DHCP_HARDWARE_ADDRESS_LEN                (6)            // DHCP hardware address length (=length of a MAC address)

#define xkPACKET_UTILS_DHCP_FLAG_UNICAST                        (0x0000)       // DHCP unicast flag.
#define xkPACKET_UTILS_DHCP_FLAG_BROADCAST                      (0x8000)       // DHCP broadcast flag.

/* UDP client and server ports */
#define xkPACKET_UTILS_DHCP_SERVER_PORT                         (67)           // DHCP UDPC server port
#define xkPACKET_UTILS_DHCP_CLIENT_PORT                         (68)           // DHCP UDPC client port

kDeclareValueEx(kFs, kArpHeader, kValue)
kDeclareValueEx(kFs, kEthernetHeader, kValue)
kDeclareValueEx(kFs, kIpHeader, kValue)
kDeclareValueEx(kFs, kUdpHeader, kValue)
kDeclareValueEx(kFs, kDhcpHeader, kValue)

k16u xkPacketUtils_IpChecksum(kByte* buffer, kSize length);

kStatus xkPacketUtils_GetDhcpOption8u(const kByte* frame, kSize frameLength, k8u code, k8u* data);
kStatus xkPacketUtils_GetDhcpOption32u(const kByte* frame, kSize frameLength, k8u code, k32u* data);

kStatus xkPacketUtils_AddDhcpOption8u(kByte** packet, kByte* packetEnd, k8u code, k8u option);
kStatus xkPacketUtils_AddDhcpOption32u(kByte** packet, kByte* packetEnd, k8u code, k32u option);
kStatus xkPacketUtils_AddDhcpOptionBuffer(kByte** packet, kByte* packetEnd, k8u code, kByte* data, kSize size);

#endif
