/** 
 * @file    kPxParallelPipe.h
 * @brief   Declares the kPxParallelPipe type. 
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_PARALLEL_PIPE_H
#define K_FIRESYNC_PX_PARALLEL_PIPE_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPxParallelPipe
 * @extends kPxPipe
 * @ingroup kFireSync-Pipe
 * @brief   Pipe execution engine that processes messages using multiple background threads.
 */
//typedef kPxPipe kPxParallelPipe;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kPxParallelPipe instance. 
 * 
 * @public                  @memberof kPxParallelPipe
 * @param   pipe            Receives constructed pipe object. 
 * @param   nodeId          Unique identifier for pipe owner (typically a node id). 
 * @param   pipeEnviron     Environment provider object. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kPxParallelPipe_Construct(kPxParallelPipe* pipe, k32u nodeId, kPxEnviron pipeEnviron, kAlloc allocator);

#include <kFireSync/Pipe/kPxParallelPipe.x.h>

#endif
