/** 
 * @file    kSvAnalogOut.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_ANALOG_OUT_X_H
#define K_FIRESYC_SERVER_ANALOG_OUT_X_H

typedef struct kSvAnalogOutClass
{
    kObjectClass base; 
    
    kSvNode node;               //Server node (parent). 
    kHxAnalogOut hwAnalog;      //Hardware analog (kHxAnalogOut).

    k64f calA0; 
    k64f calA1; 

    kAnalogOutModel analogOutModel;

} kSvAnalogOutClass; 

kDeclareClassEx(kFs, kSvAnalogOut, kObject)
        
kFsFx(kStatus) kSvAnalogOut_Init(kSvAnalogOut analog, kType type, kSvNode node, kHxAnalogOut hwAnalog, kAlloc alloc);
kFsFx(kStatus) kSvAnalogOut_VRelease(kSvAnalogOut analog);

#endif
