/** 
 * @file    kSvCamera.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CAMERA_X_H
#define K_FIRESYC_SERVER_CAMERA_X_H

/**
 * @internal
 * @struct      kSvCameraState
 * @extends     kValue
 * @ingroup     kFireSync-Server-Devices
 * @brief       Used to retain camera state settings that aren't stored in kHxCamera.
 */
typedef struct kSvCameraState
{
    kBool autoGapEnabled;           //Is automatic gap calculation enabled?
} kSvCameraState; 

kDeclareValueEx(kFs, kSvCameraState, kValue)

typedef struct kSvCameraPrimeBackup
{
    kCameraControl controlType; 
    kSize controlId; 
    kCameraOutputMode outputMode; 
    kArrayList extensions; 
    k64u delay; 
    k64u exposure; 
    k64u gap; 
    k64u leadIn; 
    k64u totalLeadIn; 
    k64u leadOut; 
    k64u totalLeadOut;
} kSvCameraPrimeBackup;

typedef struct kSvCameraClass
{
    kObjectClass base; 
    
    kSvNode node;                       //Server node (parent). 
    kHxCamera hwCamera;                 //Hardware camera (kHxCamera).

    kSize nextVideoBufferSize;          //Video buffer size after reset (device config). 
    kSize nextAlgorithmBufferSize;      //Algorithm buffer size after reset (device config). 
    kBool fpnCalibrationEnabled;        //Is FPN calibration enabled (device config).
    kBool leadOutEnabled;               //Should lead-out be included in exposure?

    kArrayList states;                  //State settings not retained by kHardware.

    kPxBlock block;                     //Input block to provide data to pipe. 

    kSvCameraPrimeBackup primeBackup;   //settings backup; used when priming hardware to run

    kHealthProbe primeCountProbe;       //Health probe to frames run during priming processes.  

} kSvCameraClass; 

kDeclareClassEx(kFs, kSvCamera, kObject)
        
kFsFx(kStatus) kSvCamera_Init(kSvCamera camera, kType type, kSvNode node, kHxCamera hwCamera, kAlloc alloc);
kFsFx(kStatus) kSvCamera_VRelease(kSvCamera camera);

kFsFx(kStatus) kSvCamera_FormatStates(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_FormatExtensions(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_FormatAlgorithm(kSvCamera camera, kSize stateIndex, kXml xml, kXmlItem item); 

kFsFx(kStatus) kSvCamera_ParseStates(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_ParseExtensions(kSvCamera camera, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvCamera_ParseAlgorithm(kSvCamera camera, kSize stateIndex, kXml xml, kXmlItem item); 

kFsFx(kStatus) kSvCamera_SetStateCount(kSvCamera camera, kSize count); 

kFsFx(kStatus) kSvCamera_UpdateBlock(kSvCamera camera); 

kFsFx(kStatus) kSvCamera_OnData(kSvCamera camera, kHxCamera hwCamera, kPointer arguments); 
kFsFx(kStatus) kSvCamera_OnInputData(kSvCamera camera, kPxPort port, kMsgInfo message);

#endif
