/** 
 * @file    kSvEncoder.h
 * @brief   Declares the kSvEncoder class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_ENCODER_H
#define K_FIRESYC_SERVER_ENCODER_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvEncoder
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @internal
 * @brief       Lightweight server wrapper for kHxEncoder. 
 */
//typedef kObject kSvEncoder;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvEncoder object.
 *
 * @public              @memberof kSvEncoder
 * @param   encoder     Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwEncoder   Encoder hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvEncoder_Construct(kSvEncoder* encoder, kSvNode node, kHxEncoder hwEncoder, kAlloc allocator);

kFsFx(kStatus) kSvEncoder_FormatDevice(kSvEncoder encoder, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvEncoder_ParseDevice(kSvEncoder encoder, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvEncoder_Format(kSvEncoder encoder, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvEncoder_Parse(kSvEncoder encoder, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvEncoder_Reset(kSvEncoder encoder);

#include <kFireSync/Server/Devices/kSvEncoder.x.h>

#endif
