/** 
 * @file    kSvLight.h
 * @brief   Declares the kSvLight class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_LIGHT_H
#define K_FIRESYC_SERVER_LIGHT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvLight
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxLight. 
 */
//typedef kObject kSvLight;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvLight object.
 *
 * @public              @memberof kSvLight
 * @param   light       Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwLight     Light hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvLight_Construct(kSvLight* light, kSvNode node, kHxLight hwLight, kAlloc allocator);

kFsFx(kStatus) kSvLight_Format(kSvLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvLight_Parse(kSvLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvLight_FormatDevice(kSvLight light, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvLight_ParseDevice(kSvLight light, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvLight_Override(kSvLight light, const kLightOverrideItem* overrides, kSize count);

kFsFx(kStatus) kSvLight_SetLightState(kSvLight light, kBool state);
kFsFx(kStatus) kSvLight_Stats(kSvLight light, kLightStats* stats);

kFsFx(kStatus) kSvLight_Trigger(kSvLight light);

kFsFx(kBool) kSvLight_ShouldPrime(kSvLight light);
kFsFx(kLightPrimingMode) kSvLight_PrimingMode(kSvLight light);
kFsFx(kStatus) kSvLight_PrepareForPrime(kSvLight light, k64u* period);
kFsFx(kStatus) kSvLight_RestoreAfterPrime(kSvLight light);

kFsFx(kStatus) kSvLight_LockOut(kSvLight light, kBool shouldLock);

#include <kFireSync/Server/Devices/kSvLight.x.h>

#endif
